//
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  N o t e b o o k   H a r d w a r e   C o n t r o l   A C P I   D L L
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  for ASUSTeK Computers
//
//  This file is provided "as is" with no expressed or implied warranty.
//  The authors accepts no liability for any damage/loss of business that
//  this product may cause.
//
//  Last Update: 06 December 2010
//
public static class ASUSTEK
{

    #region Notebook ASUS A6T : class A6T
    //
    // original class author: Manfred Jaider - M0ddEd bY Fallen Wolf
    //
    public static class A6T
    {
        public const string author = "Manfred Jaider, Fallen Wolf";

        #region Class for ASUS A6T Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_CONTROL : class WLAN_CONTROL
            //
            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for BLUETOOTH_CONTROL : class BLUETOOTH_CONTROL
            //
            public static class BLUETOOTH_CONTROL
            {
                // Properties of the value class
                public const string description = "Bluetooth";                      // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bluetooth_control = 1;                            // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (bluetooth_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 0);        // turn off the bluetooth
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 1);        // turn on the bluetooth
                        }
                    }
                }
            }
            //
            #endregion

        }
        //
        #endregion

        #region Class for Asus A6T FAN control (silent mode) : class FANS
        //
        public static class FANS
        {
            // Info
            public const string description = "Notebook FAN Control - silent mode";     // Description of current class
            public const bool default_enabled = false;                                  // false = By default the current class is disabled in NHC
            public const int icon = 2;                                                  // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Condition variables (optional)
            public static bool initialisation = true;                                  // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Name (HTTL, Package (0x08)       // <- silent mode package
            // {
            //    0x29,     // 41°C     <- FAN ON low level
            //    0x35,     // 53°C     <- FAN ON middle level 1
            //    0x3c,     // 60°C     <- FAN ON middle level 2
            //    0x41,     // 65°C     <- FAN ON high level
            //    0x46,     // 70°C     <- FAN ON very high level 1
            //    0x4b,     // 75°C     <- FAN ON very high level 2
            //    0x4d,     // 77°C     <- FAN ON maximum level
            //    0x6e      // 110°C    <- turn off computer
            // })
            // Name (LTTL, Package (0x08)       // <- silent mode package
            // {
            //    0x00,
            //    0x1e,     // 30°C     <- FAN OFF low level
            //    0x29,     // 41°C     <- FAN OFF middle level 1
            //    0x35,     // 53°C     <- FAN OFF middle level 2
            //    0x3c,     // 60°C     <- FAN OFF high level
            //    0x41,     // 65°C     <- FAN OFF very high level 1
            //    0x46,     // 70°C     <- FAN OFF very high level 2
            //    0x4b      // 75°C     <- FAN OFF maximum level
            // })
            // Name (FSTL, Package (0x08)       // <- silent mode package
            // {
            //    0x00,     // FAN off
            //    0x64,     // 100*rmp  <- FAN Low speed
            //    0x88,     // 136*rmp  <- FAN middle speed 1
            //    0xA0,     // 169*rmp  <- FAN middle speed 2
            //    0xC4,     // 196*rmp  <- FAN high speed
            //    0xE5,     // 229*rmp  <- FAN very high speed 1
            //    0xf0,     // 240*rmp  <- FAN very high speed 2
            //    0xfe      // 254*rmp  <- FAN maximum speed
            // })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 100;                              // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 100;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[1]", fan_low_speed) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED_1 : class FAN_MIDDLE_SPEED_1
            //
            public static class FAN_MIDDLE_SPEED_1
            {
                // Properties of the value class
                public const string description = "FAN middle speed 1";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed_1 = 136;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 75;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 136;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[2]", fan_middle_speed_1) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED_2 : class FAN_MIDDLE_SPEED_2
            //
            public static class FAN_MIDDLE_SPEED_2
            {
                // Properties of the value class
                public const string description = "FAN middle speed 2";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed_2 = 169;                         // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 100;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 169;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[3]", fan_middle_speed_2) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 196;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 150;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 196;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[4]", fan_high_speed) == true)     // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_VERY_HIGH_SPEED_1 : class FAN_VERY_HIGH_SPEED_1
            //
            public static class FAN_VERY_HIGH_SPEED_1
            {
                // Properties of the value class
                public const string description = "FAN very high speed 1";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_very_high_speed_1 = 229;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 75;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 229;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[5]", fan_very_high_speed_1) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            #region Value class for FAN_VERY_HIGH_SPEED_2 : class FAN_VERY_HIGH_SPEED_2
            //
            public static class FAN_VERY_HIGH_SPEED_2
            {
                // Properties of the value class
                public const string description = "FAN very high speed 1";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_very_high_speed_2 = 240;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 75;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 240;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[6]", fan_very_high_speed_2) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            //
            public static class FAN_MAXIMUM_SPEED
            {
                // Properties of the value class
                public const string description = "FAN maximum speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_maximum_speed = 254;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 200;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 254;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTS", "PKG[7]", fan_maximum_speed) == true)     // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion



            // - - -

            #region Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 30;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 30;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[1]", low_level_off) == true)    // set the low_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 41;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // minimum input value
                    public const int nhc_maximum_value = 65;                        // maximum input value
                    public const int nhc_default_value = 41;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[0]", low_level_on) == true)     // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_1_OFF : class MIDDLE_LEVEL_1_OFF
            //
            public static class MIDDLE_LEVEL_1_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level 1";         // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_1_off = 41;                          // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 41;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[2]", middle_level_1_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_1_ON : class MIDDLE_LEVEL_1_ON
            //
            public static class MIDDLE_LEVEL_1_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level 1";          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_1_on = 53;                           // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 53;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[1]", middle_level_1_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_2_OFF : class MIDDLE_LEVEL_2_OFF
            //
            public static class MIDDLE_LEVEL_2_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level 2";         // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_2_off = 53;                          // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 20;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 53;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[3]", middle_level_2_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_2_ON : class MIDDLE_LEVEL_2_ON
            //
            public static class MIDDLE_LEVEL_2_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level 2";          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_2_on = 60;                           // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[2]", middle_level_2_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 60;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[4]", high_level_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 65;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[3]", high_level_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for VERY_HIGH_LEVEL_1_OFF : class VERY_HIGH_LEVEL_1_OFF
            //
            public static class VERY_HIGH_LEVEL_1_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF very high level 1";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int very_high_level_1_off = 65;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[5]", very_high_level_1_off) == true)   // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for VERY_HIGH_LEVEL_1_ON : class VERY_HIGH_LEVEL_1_ON
            //
            public static class VERY_HIGH_LEVEL_1_ON
            {
                // Properties of the value class
                public const string description = "FAN ON very high level 1";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int very_high_level_1_on = 70;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 40;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 70;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[4]", very_high_level_1_on) == true)    // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            #region Value class for VERY_HIGH_LEVEL_2_OFF : class VERY_HIGH_LEVEL_2_OFF
            //
            public static class VERY_HIGH_LEVEL_2_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF very high level 2";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int very_high_level_2_off = 70;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 70;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[6]", very_high_level_2_off) == true)   // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for VERY_HIGH_LEVEL_2_ON : class VERY_HIGH_LEVEL_2_ON
            //
            public static class VERY_HIGH_LEVEL_2_ON
            {
                // Properties of the value class
                public const string description = "FAN ON very high level 2";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int very_high_level_2_on = 75;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 40;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 75;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[5]", very_high_level_2_on) == true)    // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            #region Value class for MAXIMUM_LEVEL_OFF : class MAXIMUM_LEVEL_OFF
            //
            public static class MAXIMUM_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF very high level 2";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int maximum_level_off = 58;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 58;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[7]", maximum_level_off) == true)   // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MAXIMIM_LEVEL_ON : class MAXIMUM_LEVEL_ON
            //
            public static class MAXIMUM_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int maximum_level_on = 77;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 40;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 77;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[6]", maximum_level_on) == true)    // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_GPE._L02");                   // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_GPE._L02");               // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

        #region Class for Asus A6T FAN control (loud mode) : class FANL
        //
        public static class FANL
        {
            // Info
            public const string description = "Notebook FAN Control - loud mode";     // Description of current class
            public const bool default_enabled = false;                                  // false = By default the current class is disabled in NHC
            public const int icon = 2;                                                  // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                                  // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Name (HTTS, Package (0x08)
            // {
            //    0x29,     // 41°C     <- FAN ON low level
            //    0x35,     // 53°C     <- FAN ON middle level 1
            //    0x3c,     // 60°C     <- FAN ON middle level 2
            //    0x41,     // 65°C     <- FAN ON high level
            //    0x46,     // 70°C     <- FAN ON very high level 1
            //    0x4b,     // 75°C     <- FAN ON very high level 2
            //    0x4d,     // 77°C     <- FAN ON maximum level
            //    0x6e      // 110°C    <- turn off computer
            // })
            // Name (LTTS, Package (0x08)
            // {
            //    0x00,
            //    0x1e,     // 30°C     <- FAN OFF low level
            //    0x29,     // 41°C     <- FAN OFF middle level 1
            //    0x35,     // 53°C     <- FAN OFF middle level 2
            //    0x3c,     // 60°C     <- FAN OFF high level
            //    0x41,     // 65°C     <- FAN OFF very high level 1
            //    0x46,     // 70°C     <- FAN OFF very high level 2
            //    0x4b      // 75°C     <- FAN OFF maximum level
            // })
            // Name (FSTS, Package (0x08)
            // {
            //    0x00,     // FAN off
            //    0x64,     // 100*rmp  <- FAN Low speed
            //    0x88,     // 136*rmp  <- FAN middle speed 1
            //    0xA0,     // 169*rmp  <- FAN middle speed 2
            //    0xC4,     // 196*rmp  <- FAN high speed
            //    0xE5,     // 229*rmp  <- FAN very high speed 1
            //    0xf0,     // 240*rmp  <- FAN very high speed 2
            //    0xfe      // 254*rmp  <- FAN maximum speed
            // })
            //

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 100;                              // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 100;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTS", "PKG[1]", fan_low_speed) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED_1 : class FAN_MIDDLE_SPEED_1
            //
            public static class FAN_MIDDLE_SPEED_1
            {
                // Properties of the value class
                public const string description = "FAN middle speed 1";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed_1 = 136;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 75;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 136;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTS", "PKG[2]", fan_middle_speed_1) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED_2 : class FAN_MIDDLE_SPEED_2
            //
            public static class FAN_MIDDLE_SPEED_2
            {
                // Properties of the value class
                public const string description = "FAN middle speed 2";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed_2 = 169;                         // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 100;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 169;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTS", "PKG[3]", fan_middle_speed_2) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 196;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 150;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 196;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTS", "PKG[4]", fan_high_speed) == true)     // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_VERY_HIGH_SPEED_1 : class FAN_VERY_HIGH_SPEED_1
            //
            public static class FAN_VERY_HIGH_SPEED_1
            {
                // Properties of the value class
                public const string description = "FAN very high speed 1";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_very_high_speed_1 = 229;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 75;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 229;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTS", "PKG[5]", fan_very_high_speed_1) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            #region Value class for FAN_VERY_HIGH_SPEED_2 : class FAN_VERY_HIGH_SPEED_2
            //
            public static class FAN_VERY_HIGH_SPEED_2
            {
                // Properties of the value class
                public const string description = "FAN very high speed 1";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_very_high_speed_2 = 240;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 75;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 240;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTS", "PKG[6]", fan_very_high_speed_2) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MAXIMUM_SPEED : class FAN_MAXIMUM_SPEED
            //
            public static class FAN_MAXIMUM_SPEED
            {
                // Properties of the value class
                public const string description = "FAN maximum speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_maximum_speed = 254;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 200;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 254;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTS", "PKG[7]", fan_maximum_speed) == true)     // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // - - -

            #region Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 30;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 30;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[1]", low_level_off) == true)    // set the low_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 41;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // minimum input value
                    public const int nhc_maximum_value = 65;                        // maximum input value
                    public const int nhc_default_value = 41;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[0]", low_level_on) == true)     // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_1_OFF : class MIDDLE_LEVEL_1_OFF
            //
            public static class MIDDLE_LEVEL_1_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level 1";         // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_1_off = 41;                          // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 41;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[2]", middle_level_1_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_1_ON : class MIDDLE_LEVEL_1_ON
            //
            public static class MIDDLE_LEVEL_1_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level 1";          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_1_on = 53;                           // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 53;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[1]", middle_level_1_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_2_OFF : class MIDDLE_LEVEL_2_OFF
            //
            public static class MIDDLE_LEVEL_2_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level 2";         // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_2_off = 53;                          // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 20;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 53;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[3]", middle_level_2_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_2_ON : class MIDDLE_LEVEL_2_ON
            //
            public static class MIDDLE_LEVEL_2_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level 2";          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_2_on = 60;                           // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[2]", middle_level_2_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 60;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[4]", high_level_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 65;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[3]", high_level_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for VERY_HIGH_LEVEL_1_OFF : class VERY_HIGH_LEVEL_1_OFF
            //
            public static class VERY_HIGH_LEVEL_1_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF very high level 1";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int very_high_level_1_off = 65;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[5]", very_high_level_1_off) == true)   // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for VERY_HIGH_LEVEL_1_ON : class VERY_HIGH_LEVEL_1_ON
            //
            public static class VERY_HIGH_LEVEL_1_ON
            {
                // Properties of the value class
                public const string description = "FAN ON very high level 1";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int very_high_level_1_on = 70;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 40;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 70;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[4]", very_high_level_1_on) == true)    // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            #region Value class for VERY_HIGH_LEVEL_2_OFF : class VERY_HIGH_LEVEL_2_OFF
            //
            public static class VERY_HIGH_LEVEL_2_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF very high level 2";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int very_high_level_2_off = 70;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 70;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[6]", very_high_level_2_off) == true)   // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for VERY_HIGH_LEVEL_2_ON : class VERY_HIGH_LEVEL_2_ON
            //
            public static class VERY_HIGH_LEVEL_2_ON
            {
                // Properties of the value class
                public const string description = "FAN ON very high level 2";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int very_high_level_2_on = 75;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 40;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 75;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[5]", very_high_level_2_on) == true)    // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            #region Value class for MAXIMUM_LEVEL_OFF : class MAXIMUM_LEVEL_OFF
            //
            public static class MAXIMUM_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF very high level 2";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int maximum_level_off = 58;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 58;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTS", "PKG[7]", maximum_level_off) == true)   // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MAXIMIM_LEVEL_ON : class MAXIMUM_LEVEL_ON
            //
            public static class MAXIMUM_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int maximum_level_on = 77;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 40;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 77;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTS", "PKG[6]", maximum_level_on) == true)    // set the value in the package
                        {
                            if (initialisation == false)
                            {
                                return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                            }
                            else
                            {
                                return true;                                        // on NHC initialisation skip the ThermalZone refresh
                            }
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_GPE._L02");                   // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_GPE._L02");               // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook ASUS A6J : class A6
    //
    // class author: Weed_M@x
    //
    public static class A6J
    {
        public const string author = "Weed_M@x";

        #region Class for Asus A6J LCD Brightness control (it must have the name BRIGHTNESS)
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";     // Description of current class
            public const bool default_enabled = true;          // true = By default the current class is enabled in NHC
            public const int icon = 1;              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            // Value class for brightness_level
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level"; // Description of current value
                public const bool nhc_visible = true;         // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;         // It must have the same name as the class (case are ignored)
            }

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);   // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        //
        #endregion

        #region Class for A6J Hardware control
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";       // Description of current class
            public const bool default_enabled = true;          // true = By default the current class is enabled in NHC
            public const int icon = 0;              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Value class for Bluetooth
            public static class BT
            {
                // Properties of the value class
                public const string description = "Bluetooth?";     // Description of current value
                public const bool nhc_visible = true;         // true -> value is visible in NHC

                // Value
                public static int bt = 0;         // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;       // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;       // the minimum input value
                    public const int nhc_maximum_value = 1;       // the maximum input value
                    public const int nhc_default_value = 1;       // the default value
                    public static bool nhc_on_write()       // Optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        bool result = ACPI.METHOD.SetValue("_SB.ATKD.BLED", bt);
                        return result;
                    }
                }
            }

            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        bool result = ACPI.METHOD.SetValue("_SB.ATKD.WLED", wlan_control);
                        return result;
                    }
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook ASUS A7D : class A7D
    //
    // class author: Manfred Jaider
    //
    public static class A7D
    {
        public const string author = "Manfred Jaider";

        #region Class for Asus A7D LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion
           
            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        //
        #endregion

        #region Class for ASUS A7D Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_CONTROL : class WLAN_CONTROL
            //
            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for BLUETOOTH_CONTROL : class BLUETOOTH_CONTROL
            //
            public static class BLUETOOTH_CONTROL
            {
                // Properties of the value class
                public const string description = "Bluetooth";                      // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bluetooth_control = 1;                            // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (bluetooth_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 0);        // turn off the bluetooth
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 1);        // turn on the bluetooth
                        }
                    }
                }
            }
            //
            #endregion

        }
        //
        #endregion

        #region Class for Asus A7D FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // OperationRegion (RAMW, SystemMemory, RAMB, 0x0100)
            // Field (RAMW, AnyAcc, NoLock, Preserve)
            // {
            //    . . .
            //    . . .
            //    SFUN,   8,
            //    TPSV,   8,    // 105°C    <- Passive Cooling Temperature
            //    TAC0,   8,    // 60°C     <- Active Cooling Temperature
            //    TCRT,   8,    // 110°C    <- Critical Temperature
            //    TDO1,   8,
            //    TDO2,   8,
            //    PPSV,   8,    // 80°C     <- PLCY Passive Cooling Temperature
            //    PAC0,   8,    // 95°C     <- PLCY Active Cooling Temperature
            //    T0HL,   8,    // 110°C    <- FAN ON Critical Temperature
            //    T0LL,   8,    // 100°C    <- FAN OFF Critical Temperature
            //    T0F1,   8,    // 255*rmp  <- FAN maximum speed
            //    T0F2,   8,    // 0
            //    T1HL,   8,    // 105°C    <- FAN ON Passive Cooling Temperature
            //    T1LL,   8,    // 90°C     <- FAN OFF Passive Cooling Temperature
            //    T1F1,   8,    // 255*rmp  <- FAN maximum speed
            //    T1F2,   8,    // 0
            //    T2HL,   8,    // 95°C     <- FAN ON very high level
            //    T2LL,   8,    // 75°C     <- FAN OFF very high level
            //    T2F1,   8,    // 255*rmp  <- FAN very high speed
            //    T2F2,   8,    // 0
            //    T3HL,   8,    // 80°C     <- FAN ON high level
            //    T3LL,   8,    // 65°C     <- FAN OFF high level
            //    T3F1,   8,    // 216*rmp  <- FAN high speed
            //    T3F2,   8,    // 0
            //    T4HL,   8,    // 70°C     <- FAN ON middle level
            //    T4LL,   8,    // 57°C     <- FAN OFF middle level
            //    T4F1,   8,    // 128*rmp  <- FAN middle speed
            //    T4F2,   8,    // 0
            //    T5HL,   8,    // 62°C     <- FAN ON low level
            //    T5LL,   8,    // 45°C     <- FAN OFF low level
            //    T5F1,   8,    // 91*rmp   <- FAN low speed
            //    T5F2,   8,    // 0
            //    T6HL,   8,    // 50°C     <- FAN ON minimum level
            //    T6LL,   8,    // 20°C     <- FAN OFF minimum level
            //    T6F1,   8,    // 0*rmp    <- FAN minimum speed
            //    T6F2,   8,    // 0
            //    T7HL,   8,    // 30°C
            //    T7LL,   8,    // 0°C
            //    T7F1,   8,    // 0*rmp
            //    T7F2,   8,    // 0
            //    SLPT,   8,
            //    . . .
            //    . . .
            // }
            //
            //  Info:   To get the above values you can use the ACPI.FIELD.Read("name", ref value) function
            //          Example: int value = 0; ACPI.FIELD.Read("TAC3", ref value);


            #region Value class for FAN_MIN_SPEED : class FAN_MIN_SPEED
            //
            public static class FAN_MIN_SPEED
            {
                // Properties of the value class
                public const string description = "FAN minimum speed";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_min_speed = 0;                                // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 0;                         // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T6F1", fan_min_speed) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 91;                               // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 91;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T5F1", fan_low_speed) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed = 128;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 50;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 128;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T4F1", fan_middle_speed) == true)     // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 216;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 100;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 216;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T3F1", fan_high_speed) == true)       // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for MIN_LEVEL_OFF : class MIN_LEVEL_OFF
            //
            public static class MIN_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF minimum level";          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int min_level_off = 20;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 20;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T6LL", min_level_off) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for MIN_LEVEL_ON : class MIN_LEVEL_ON
            //
            public static class MIN_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON minimum level";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int min_level_on = 50;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T6HL", min_level_on) == true)         // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 45;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 20;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T5LL", low_level_off) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 62;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 62;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T5HL", low_level_on) == true)         // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for MIDDLE_LEVEL_OFF : class MIDDLE_LEVEL_OFF
            //
            public static class MIDDLE_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_off = 57;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 40;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 57;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T4HL", middle_level_off) == true)     // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_on = 70;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 50;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 70;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T4HL", middle_level_on) == true)      // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 65;                              // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 45;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T3LL", high_level_off) == true)       // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 80;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 60;                        // minimum input value
                    public const int nhc_maximum_value = 90;                        // maximum input value
                    public const int nhc_default_value = 80;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("T3HL", high_level_on) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_TZ.TCHG");                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_TZ.TCHG");                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook ASUS A8Fm : class A8Fm
    //
    // class author: Manfred Jaider, moderation for A8Fm: Piotr Kocybik
    //
    public static class A8Fm
    {
        public const string author = "Manfred Jaider, Piotr Kocybik";

        #region Class for ASUS A8Fm LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        //
        #endregion

        #region Class for ASUS A8Fm Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_CONTROL : class WLAN_CONTROL
            //
            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for BLUETOOTH_CONTROL : class BLUETOOTH_CONTROL
            //
            public static class BLUETOOTH_CONTROL
            {
                // Properties of the value class
                public const string description = "Bluetooth";                      // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bluetooth_control = 1;                            // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (bluetooth_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 0);        // turn off the bluetooth
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 1);        // turn on the bluetooth
                        }
                    }
                }
            }
            //
            #endregion

        }
        //
        #endregion

        #region Class for Asus A8Fm FAN control : class FAN
        public static class FAN
        {
            public const string description = "ACPI fan manual control";
            public const bool default_enabled = false;
            public const int icon = 2;

            public static class FAN_ON_OFF
            {
                public const string description = "Current fan state (on\\off)";
                public const bool nhc_visible = true;
                public static int fan_on_off = 0;
                public const string unit = "off|on";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 1;
                    public const int nhc_default_value = 1;
                    public static bool initialisation = false;

                    public static bool nhc_on_write()
                    {
                        if (!initialisation)
                        {
                            int a = 0;
                            ACPI.NAME.Read("_TZ.PLCY", ref a);
                            FAN_ON_OFF.fan_on_off = ((a == 0) ? 1 : 0);
                            initialisation = true;
                            return true;
                        }
                        if (fan_on_off != 0)
                        {
                            ACPI.NAME.Write("_TZ.PLCY", 0);
                            int a, b, c, res;
                            a = 0x84;
                            b = FAN_SPEED.fan_speed;
                            c = 0xC4;
                            res = ((a << 16) + (b << 8) + (c));
                            ACPI.METHOD.SetValue("_TZ.TMSS", 0);
                            ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                            ACPI.METHOD.Call("_TZ.UMIT");
                        }
                        else
                        {
                            ACPI.NAME.Write("_TZ.PLCY", 1);
                            ACPI.METHOD.Call("_TZ.TCHG");
                        }
                        return true;
                    }
                }
            }
            public static class FAN_SPEED
            {
                public const string description = "Current fan speed (0 to 255)";
                public const bool nhc_visible = true;
                public static int fan_speed = 0;
                public const string unit = "";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 144;
                    public static bool initialisation = false;

                    public static bool nhc_on_write()
                    {
                        if (!initialisation)
                        {
                            int a = 0;
                            ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref a);
                            FAN_SPEED.fan_speed = a;
                            initialisation = true;
                            return true;
                        }
                        int is_fan_off = 0;
                        ACPI.NAME.Read("_TZ.PLCY", ref is_fan_off);
                        if (is_fan_off == 0)
                        {
                            int a, b, c, res;
                            a = 0x84;
                            b = fan_speed;
                            c = 0xC4;
                            res = ((a << 16) + (b << 8) + (c));
                            ACPI.METHOD.SetValue("_TZ.TMSS", 0);
                            ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                            ACPI.METHOD.Call("_TZ.UMIT");
                        }
                        return true;
                    }
                }
            }
        }
        #endregion

        #region Class for Asus A8Fm QFAN control : class QFAN
        public static class QFAN
        {
            public const string description = "ACPI fan automatic temperature control";
            public const bool default_enabled = false;
            public const int icon = 2;

            #region Value class for QFAN_CPUTemperature : class QFAN_CPUTemperature
            public static class QFAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int qfan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for QFAN_FanSpeed : class QFAN_FanSpeed
            public static class QFAN_FanSpeed
            {
                public const string description = "Current fan speed (0 - 255)";
                public const bool nhc_visible = true;
                public static int qfan_fanspeed = 0;
                public const string unit = "";
            }
            #endregion

            #region Value class for QFAN_CPUTemperaturePrevious : class QFAN_CPUTemperaturePrevious
            public static class QFAN_CPUTemperaturePrevious
            {
                public const string description = "";
                public const bool nhc_visible = false;
                public static int qfan_cputemperatureprevious = -1;
                public const string unit = "";
                public static int qfan_refreshdivider = 0;
            }
            #endregion

            #region Value class for QFAN_CPUTemperatureDesired : class QFAN_CPUTemperatureDesired
            public static class QFAN_CPUTemperatureDesired
            {
                public const string description = "Desired CPU temperature";
                public const bool nhc_visible = true;
                public static int qfan_cputemperaturedesired = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 45;
                    public static bool initialisation = false;

                    public static bool nhc_on_write()
                    {
                        if (!initialisation)
                        {
                            int a = 0;
                            ACPI.FIELD.Read("_TZ.THRM._TMP", ref a);
                            a = (a - 2732) / 10;
                            QFAN_CPUTemperature.qfan_cputemperature = a;
                            QFAN_CPUTemperaturePrevious.qfan_cputemperatureprevious = a;
                            ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref a);
                            QFAN_FanSpeed.qfan_fanspeed = a;
                            initialisation = true;
                            return true;
                        }
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for QFAN_CPUFanSpeedDesired : class QFAN_CPUFanSpeedDesired
            public static class QFAN_CPUFanSpeedDesired
            {
                public const string description = "Desired fan speed";
                public const bool nhc_visible = true;
                public static int qfan_cpufanspeeddesired = 0;
                public const string unit = "";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 144;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for QFAN_CPUFanSpeedStep : class QFAN_CPUFanSpeedStep
            public static class QFAN_CPUFanSpeedStep
            {
                public const string description = "Fan speed step";
                public const bool nhc_visible = true;
                public static int qfan_cpufanspeedstep = 1;
                public const string unit = "";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 1;
                    public const int nhc_maximum_value = 30;
                    public const int nhc_default_value = 1;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            public const double refresh_interval = 1;
            public static bool refresh()
            {
                if (QFAN_CPUTemperaturePrevious.qfan_refreshdivider < 3)
                {
                    QFAN_CPUTemperaturePrevious.qfan_refreshdivider++;
                    return true;
                }
                QFAN_CPUTemperaturePrevious.qfan_refreshdivider = 0;

                int temperature_current = 0;
                int temperature_desired = 0;
                int speed_current = 0;
                int speed_previous = 0;
                int speed_desired = 0;
                int speed_step = 0;

                temperature_desired = QFAN_CPUTemperatureDesired.qfan_cputemperaturedesired;
                speed_desired = QFAN_CPUFanSpeedDesired.qfan_cpufanspeeddesired;
                speed_step = QFAN_CPUFanSpeedStep.qfan_cpufanspeedstep;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref temperature_current);
                temperature_current = (temperature_current - 2732) / 10;
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref speed_current);

                if (QFAN_CPUTemperaturePrevious.qfan_cputemperatureprevious != -1)
                {
                    if (temperature_current != temperature_desired)
                    {
                        if (temperature_current > temperature_desired)
                        {
                            if (temperature_current == QFAN_CPUTemperaturePrevious.qfan_cputemperatureprevious)
                            {
                                speed_previous = speed_current;
                                speed_current += speed_step;
                                if (speed_current > 255) speed_current = 255;
                                if (speed_current != speed_previous) QFAN_SetCPUFanSpeed(speed_current);
                            }
                        }
                        else
                        {
                            if (QFAN_CPUTemperaturePrevious.qfan_cputemperatureprevious == temperature_current)
                            {
                                if (speed_current > speed_desired)
                                {
                                    speed_previous = speed_current;
                                    speed_current -= speed_step;
                                    if (speed_current < 0) speed_current = 0;
                                    if (speed_current != speed_previous) QFAN_SetCPUFanSpeed(speed_current);
                                }
                            }
                        }
                    }
                }

                QFAN_CPUTemperature.qfan_cputemperature = temperature_current;
                QFAN_FanSpeed.qfan_fanspeed = speed_current;
                QFAN_CPUTemperaturePrevious.qfan_cputemperatureprevious = temperature_current;

                return true;
            }

            private static bool QFAN_SetCPUFanSpeed(int speed)
            {
                ACPI.NAME.Write("_TZ.PLCY", 0);
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_TZ.TMSS", 0);
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                ACPI.METHOD.Call("_TZ.UMIT");
                return true;
            }
        }
        #endregion

        #region Class for Asus A8Fm SFAN control : class SFAN
        public static class SFAN
        {
            public const string description = "ACPI fan automatic speed control";
            public const bool default_enabled = false;
            public const int icon = 2;

            #region Value class for SFAN_CPUTemperature : class SFAN_CPUTemperature
            public static class SFAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for SFAN_FanSpeed : class SFAN_FanSpeed
            public static class SFAN_FanSpeed
            {
                public const string description = "Current fan speed (0 - 255)";
                public const bool nhc_visible = true;
                public static int sfan_fanspeed = 0;
                public const string unit = "";
                public static int sfan_refreshdivider = 0;
            }
            #endregion

            #region Value class for SFAN_UpdateSpeed : class SFAN_UpdateSpeed
            public static class SFAN_UpdateSpeed
            {
                public const string description = "Update once in";
                public const bool nhc_visible = true;
                public static int sfan_updatespeed = 0;
                public const string unit = " second(s)";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 1;
                    public const int nhc_maximum_value = 20;
                    public const int nhc_default_value = 6;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile1 : class SFAN_SpeedProfile1
            public static class SFAN_SpeedProfile1
            {
                public const string description = "Profile 1, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile1 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 57;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile1_S : class SFAN_SpeedProfile1_S
            public static class SFAN_SpeedProfile1_S
            {
                public const string description = "Profile 1, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile1_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 105;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile2 : class SFAN_SpeedProfile2
            public static class SFAN_SpeedProfile2
            {
                public const string description = "Profile 2, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile2 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile2_S : class SFAN_SpeedProfile2_S
            public static class SFAN_SpeedProfile2_S
            {
                public const string description = "Profile 2, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile2_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 144;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile3 : class SFAN_SpeedProfile3
            public static class SFAN_SpeedProfile3
            {
                public const string description = "Profile 3, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile3 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 67;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile3_S : class SFAN_SpeedProfile3_S
            public static class SFAN_SpeedProfile3_S
            {
                public const string description = "Profile 3, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile3_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 165;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile4 : class SFAN_SpeedProfile4
            public static class SFAN_SpeedProfile4
            {
                public const string description = "Profile 4, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile4 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile4_S : class SFAN_SpeedProfile4_S
            public static class SFAN_SpeedProfile4_S
            {
                public const string description = "Profile 4, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile4_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 200;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile5 : class SFAN_SpeedProfile5
            public static class SFAN_SpeedProfile5
            {
                public const string description = "Profile 5, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile5 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 75;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile5_S : class SFAN_SpeedProfile5_S
            public static class SFAN_SpeedProfile5_S
            {
                public const string description = "Profile 5, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile5_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 215;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile6 : class SFAN_SpeedProfile6
            public static class SFAN_SpeedProfile6
            {
                public const string description = "Profile 6, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile6 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile6_S : class SFAN_SpeedProfile6_S
            public static class SFAN_SpeedProfile6_S
            {
                public const string description = "Profile 6, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile6_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 255;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfileDefault : class SFAN_SpeedProfileDefault
            public static class SFAN_SpeedProfileDefault
            {
                public const string description = "Default profile, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofiledefault = 255;
                public const string unit = "";
                public static bool initialisation = false;
            }
            #endregion

            public const double refresh_interval = 1;
            public static bool refresh()
            {
                if (SFAN_FanSpeed.sfan_refreshdivider < SFAN_UpdateSpeed.sfan_updatespeed)
                {
                    SFAN_FanSpeed.sfan_refreshdivider++;
                    return true;
                }
                SFAN_FanSpeed.sfan_refreshdivider = 0;

                int temperature_current = 0;
                int speed_current = 0;

                ACPI.FIELD.Read("_TZ.THRM._TMP", ref temperature_current);
                temperature_current = (temperature_current - 2732) / 10;
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref speed_current);

                int[] t_ = new int[6];
                t_[0] = SFAN_SpeedProfile1.sfan_speedprofile1;
                t_[1] = SFAN_SpeedProfile2.sfan_speedprofile2;
                t_[2] = SFAN_SpeedProfile3.sfan_speedprofile3;
                t_[3] = SFAN_SpeedProfile4.sfan_speedprofile4;
                t_[4] = SFAN_SpeedProfile5.sfan_speedprofile5;
                t_[5] = SFAN_SpeedProfile6.sfan_speedprofile6;

                int[] s_ = new int[6];
                s_[0] = SFAN_SpeedProfile1_S.sfan_speedprofile1_s;
                s_[1] = SFAN_SpeedProfile2_S.sfan_speedprofile2_s;
                s_[2] = SFAN_SpeedProfile3_S.sfan_speedprofile3_s;
                s_[3] = SFAN_SpeedProfile4_S.sfan_speedprofile4_s;
                s_[4] = SFAN_SpeedProfile5_S.sfan_speedprofile5_s;
                s_[5] = SFAN_SpeedProfile6_S.sfan_speedprofile6_s;

                int tmp;
                for (int i = 1; i < 6; i++)
                    for (int j = 5; j > 0; j--)
                        if (t_[j - 1] > t_[j])
                        {
                            tmp = t_[j];
                            t_[j] = t_[j - 1];
                            t_[j - 1] = tmp;
                            tmp = s_[j];
                            s_[j] = s_[j - 1];
                            s_[j - 1] = tmp;
                        }

                bool ok = false;
                for (int i = 0; i < 6; i++)
                    if (temperature_current <= t_[i])
                    {
                        if (s_[i] != speed_current) SFAN_SetCPUFanSpeed(s_[i]);
                        ok = true;
                        break;
                    }

                if (!ok) SFAN_SetCPUFanSpeed(255);

                SFAN_CPUTemperature.sfan_cputemperature = temperature_current;
                SFAN_FanSpeed.sfan_fanspeed = speed_current;

                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed)
            {
                ACPI.NAME.Write("_TZ.PLCY", 0);
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_TZ.TMSS", 0);
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                ACPI.METHOD.Call("_TZ.UMIT");
                return true;
            }
        }
        #endregion

    }
    #endregion

    #region Notebook ASUS A8J : class A8J
    //
    // class author: volker
    //
    public static class A8J
    {
        public const string author = "volker";

        #region Class for ASUS A8J LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 14;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return A7D.BRIGHTNESS.set_brightness(new_level);                    // we can use the ASUS A7D set_brightness function (brightness control works in the same way)
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                return A7D.BRIGHTNESS.get_brightness(ref level);                    // we can use the ASUS A7D get_brightness function (brightness control works in the same way)
            }
        }
        //
        #endregion

        #region Class for ASUS W3V Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_CONTROL : class WLAN_CONTROL
            //
            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for BLUETOOTH_CONTROL : class BLUETOOTH_CONTROL
            //
            public static class BLUETOOTH_CONTROL
            {
                // Properties of the value class
                public const string description = "Bluetooth";                      // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bluetooth_control = 1;                            // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (bluetooth_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 0);        // turn off the bluetooth
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 1);        // turn on the bluetooth
                        }
                    }
                }
            }
            //
            #endregion

        }
        //
        #endregion

        #region Class for Asus A8J Manual FAN control : class MANUAL_FAN
        //
        public static class MANUAL_FAN
        {
            public const string description = "Manual FAN Control";
            public const bool default_enabled = false;
            public const int icon = 2;

            #region  Value class for FAN_ON_OFF : class FAN_ON_OFF
            //
            public static class FAN_ON_OFF
            {
                public const string description = "FAN";
                public const bool nhc_visible = true;
                public static int fan_on_off = 0;
                public const string unit = "ON|OFF";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 1;
                    public const int nhc_default_value = 1;

                    public static bool nhc_on_write()
                    {
                        bool result = ACPI.NAME.Write("_TZ.PLCY", (byte)fan_on_off);
                        ACPI.METHOD.Call("_TZ.TCHG");
                        return result;
                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region Class for Asus A8J Automatic FAN control : class AUTOMATIC_FAN
        //
        public static class AUTOMATIC_FAN
        {
            // true = By default the current class is enabled in NHC
            public const bool default_enabled = true;
            // Description of current class
            public const string description = "Automatic FAN Control";
            // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public const int icon = 2;

            public static int FAN_ON_TEMP = 55;
            public static int FAN_OFF_TEMP = 38;
            const int BUILT_IN_FAN_OFF_TEMP = 39;

            #region Value class for CPUTEMP_VALUE : class CPUTEMP_VALUE
            //
            public static class CPUTEMP_VALUE
            {
                // Properties of the value class
                public const string description = "Actual CPU temperature";
                public const bool nhc_visible = true;
                // Value
                public static int CPUTEMP_value = 0;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // Unit of value
            }
            //
            #endregion

            #region Value class for FANSTATUS : class FANSTATUS
            //
            public static class FANSTATUS
            {
                // Properties of the value class
                public const string description = "Actual FAN status";
                public const bool nhc_visible = true;
                // Value
                public static int fanstatus = 0;                                // It must have the same name as the class (case are ignored)
                public const string unit = " ON = 0 | OFF = 1";                                    // Unit of value
            }
            //
            #endregion

            #region Value class for FANON_VALUE : class FANON_VALUE
            //
            public static class FANON_VALUE
            {
                // Properties of the value class
                public const string description = "FAN ON Temperature";
                public const bool nhc_visible = true;

                // Value
                public static int FANON_value = FAN_ON_TEMP;                        // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // Unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 55;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (FANON_value <= FAN_OFF_TEMP)
                        {
                            FANON_value = FAN_OFF_TEMP + 1;
                        }
                        FAN_ON_TEMP = FANON_value;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FANOFF_VALUE : class FANOFF_VALUE
            //
            public static class FANOFF_VALUE
            {
                // Properties of the value class
                public const string description = "FAN OFF Temperature";
                public const bool nhc_visible = true;

                // Value
                public static int FANOFF_value = FAN_OFF_TEMP;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // Unit of value

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 33;                        // minimum input value
                    public static int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 38;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (FANOFF_value >= FAN_ON_TEMP)
                        {
                            FANOFF_value = FAN_ON_TEMP - 1;
                        }
                        FAN_OFF_TEMP = FANOFF_value;
                        return true;
                    }
                }
            }
            //
            #endregion

            public const double refresh_interval = 15.2;
            public static bool refresh()
            {
                int ctmp_val = 0;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref ctmp_val);
                CPUTEMP_VALUE.CPUTEMP_value = (ctmp_val - 2732) / 10;
                //int fanstatus = 0;
                //ACPI.NAME.Read("_TZ.PLCY",ref fanstatus);
                //FANSTATUS.fanstatus = fanstatus;
                //Fan is on
                if (FANSTATUS.fanstatus == 0)
                {
                    if (CPUTEMP_VALUE.CPUTEMP_value < FAN_OFF_TEMP)
                    {
                        ACPI.NAME.Write("_TZ.PLCY", (byte)1);
                        ACPI.METHOD.Call("_TZ.TCHG");
                        FANSTATUS.fanstatus = 1;
                    }
                }
                // Fan is on
                else if (FANSTATUS.fanstatus == 1)
                {
                    if (CPUTEMP_VALUE.CPUTEMP_value > FAN_ON_TEMP)
                    {
                        ACPI.NAME.Write("_TZ.PLCY", (byte)0);
                        ACPI.METHOD.Call("_TZ.TCHG");
                        FANSTATUS.fanstatus = 0;
                    }
                }
                return true;
            }
        }
        //
        #endregion
    }
    //
    #endregion

    #region Notebook Asus A8JN : class A8JN
    //
    // class author: nullpointer@mail.ru, last updated: 23:10 12.03.2007
    //
    public static class A8JN
    {
        public const string author = "nullpointer@mail.ru";

        #region Class for Asus A8JN FAN control : class FAN
        public static class FAN
        {
            public const string description = "ACPI fan manual software control";
            public const bool default_enabled = false;
            public const int icon = 2;

            #region Value class for FAN_ON_OFF : class FAN_ON_OFF
            public static class FAN_ON_OFF
            {
                public const string description = "Current fan state (on\\off)";
                public const bool nhc_visible = true;
                public static int fan_on_off = 0;
                public const string unit = "off|on";

                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 1;
                    public const int nhc_default_value = 1;

                    public static bool nhc_on_write()
                    {
                        if (initialisation)
                        {
                            int a1 = 0, a2 = 0;
                            ACPI.NAME.Read("_TZ.PLCY", ref a1);
                            ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref a2);
                            FAN_SPEED.fan_speed = a2;
                            if ((a1 == 1) || (a2 < 0x30))
                            {
                                FAN_ON_OFF.fan_on_off = 0;
                            }
                            else
                            {
                                FAN_ON_OFF.fan_on_off = 1;
                            }
                            return true;
                        }
                        ACPI.NAME.Write("_TZ.PLCY", 0);
                        int[] inArg = { 0, 0 };
                        inArg[0] = FAN_WARNING.fan_warning; // Higher temperature limit
                        inArg[1] = 0;  // Lower temperature limit
                        int[] outArg = { 0 };
                        ACPI.METHOD.Call("_TZ.WTML", inArg, 2, ref outArg, 0);
                        int a, b, c, res;
                        a = 0x84;
                        if (fan_on_off != 0) b = FAN_SPEED.fan_speed;
                        else b = 0x13;
                        c = 0xC4;
                        res = ((a << 16) + (b << 8) + (c));
                        ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                        ACPI.METHOD.Call("_TZ.UMIT");
                        if (FAN_ON_OFF.fan_on_off != 0)
                        {
                            int aa = 0;
                            ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref aa);
                            FAN_SPEED.fan_speed = aa;
                        }
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for FAN_SPEED : class FAN_SPEED
            public static class FAN_SPEED
            {
                public const string description = "Current fan speed (0 to 255)";
                public const bool nhc_visible = true;
                public static int fan_speed = 0;
                public const string unit = "";

                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 144;

                    public static bool nhc_on_write()
                    {
                        if (initialisation)
                        {
                            int a1 = 0;
                            ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref a1);
                            FAN_SPEED.fan_speed = a1;
                            return true;
                        }
                        if (FAN_ON_OFF.fan_on_off == 1)
                        {
                            int[] inArg = { 0, 0 };
                            inArg[0] = FAN_WARNING.fan_warning; // Higher temperature limit
                            inArg[1] = 0;  // Lower temperature limit
                            int[] outArg = { 0 };
                            ACPI.METHOD.Call("_TZ.WTML", inArg, 2, ref outArg, 0);
                            int a, b, c, res;
                            a = 0x84;
                            b = fan_speed;
                            c = 0xC4;
                            res = ((a << 16) + (b << 8) + (c));
                            ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                            ACPI.METHOD.Call("_TZ.UMIT");
                        }
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for FAN_WARNING : class FAN_WARNING
            public static class FAN_WARNING
            {
                public const string description = "Hardware fan control enabled if CPU temperature is over";
                public const bool nhc_visible = true;
                public static int fan_warning = 55;
                public const string unit = "°C";

                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 45;
                    public const int nhc_maximum_value = 55;
                    public const int nhc_default_value = 70;

                    public static bool nhc_on_write()
                    {
                        if (initialisation)
                        {
                            return true;
                        }
                        if (FAN_ON_OFF.fan_on_off == 1)
                        {
                            int[] inArg = { 0, 0 };
                            inArg[0] = FAN_WARNING.fan_warning; // Higher temperature limit
                            inArg[1] = 0;  // Lower temperature limit
                            int[] outArg = { 0 };
                            ACPI.METHOD.Call("_TZ.WTML", inArg, 2, ref outArg, 0);
                            int a, b, c, res;
                            a = 0x84;
                            b = FAN_SPEED.fan_speed;
                            c = 0xC4;
                            res = ((a << 16) + (b << 8) + (c));
                            ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                            ACPI.METHOD.Call("_TZ.UMIT");
                        }
                        return true;
                    }
                }
            }
            #endregion
        }
        #endregion

        #region Class for Asus A8JN SFAN control : class SFAN
        public static class SFAN
        {
            public const string description = "ACPI fan automatic software control";
            public const bool default_enabled = false;
            public const int icon = 2;

            #region Value class for SFAN_CPUTemperature : class SFAN_CPUTemperature
            public static class SFAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for SFAN_FanSpeed : class SFAN_FanSpeed
            public static class SFAN_FanSpeed
            {
                public const string description = "Current fan speed approximately";
                public const bool nhc_visible = true;
                public static int sfan_fanspeed = 0;
                public const string unit = " rpm";
            }
            #endregion

            #region Value class for SFAN_Profile : class SFAN_Profile
            public static class SFAN_Profile
            {
                public const string description = "Current profile";
                public const bool nhc_visible = true;
                public static int sfan_profile = 0;
                public const string unit = "";

                public static bool init_done = false;

                public static int[] t_ = { 0, 0, 0, 0, 0, 0 };
                public static int[] s_ = { 0, 0, 0, 0, 0, 0 };
                public static int[] d_ = { 0, 0, 0, 0, 0, 0 };
                public static int[] i_ = { 1, 2, 3, 4, 5, 6 };

                public static int sfan_profile_i = -1;
            }
            #endregion

            #region Value class for SFAN_WARNING : class SFAN_WARNING
            public static class SFAN_WARNING
            {
                public const string description = "Hardware fan control enabled if CPU temperature is over";
                public const bool nhc_visible = true;
                public static int sfan_warning = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for SFAN_UpdateSpeed : class SFAN_UpdateSpeed
            public static class SFAN_UpdateSpeed
            {
                public const string description = "Update once in";
                public const bool nhc_visible = true;
                public static int sfan_updatespeed = 0;
                public const string unit = " second(s)";

                public static int sfan_refreshdivider = 0;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 1;
                    public const int nhc_maximum_value = 20;
                    public const int nhc_default_value = 5;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV1 : class SFAN_DIV1
            public static class SFAN_DIV1
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div1 = 1;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile1_S : class SFAN_SpeedProfile1_S
            public static class SFAN_SpeedProfile1_S
            {
                public const string description = "Profile 1, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile1_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 0;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(1, SFAN_SpeedProfile1.sfan_speedprofile1, SFAN_SpeedProfile1_S.sfan_speedprofile1_s, SFAN_SpeedProfile1_D.sfan_speedprofile1_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile1 : class SFAN_SpeedProfile1
            public static class SFAN_SpeedProfile1
            {
                public const string description = "Profile 1, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile1 = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 50;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(1, SFAN_SpeedProfile1.sfan_speedprofile1, SFAN_SpeedProfile1_S.sfan_speedprofile1_s, SFAN_SpeedProfile1_D.sfan_speedprofile1_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile1_D : class SFAN_SpeedProfile1_D
            public static class SFAN_SpeedProfile1_D
            {
                public const string description = "Profile 1, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile1_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 0;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(1, SFAN_SpeedProfile1.sfan_speedprofile1, SFAN_SpeedProfile1_S.sfan_speedprofile1_s, SFAN_SpeedProfile1_D.sfan_speedprofile1_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV2 : class SFAN_DIV2
            public static class SFAN_DIV2
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div2 = 2;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile2_S : class SFAN_SpeedProfile2_S
            public static class SFAN_SpeedProfile2_S
            {
                public const string description = "Profile 2, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile2_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 144;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(2, SFAN_SpeedProfile2.sfan_speedprofile2, SFAN_SpeedProfile2_S.sfan_speedprofile2_s, SFAN_SpeedProfile2_D.sfan_speedprofile2_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile2 : class SFAN_SpeedProfile2
            public static class SFAN_SpeedProfile2
            {
                public const string description = "Profile 2, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile2 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(2, SFAN_SpeedProfile2.sfan_speedprofile2, SFAN_SpeedProfile2_S.sfan_speedprofile2_s, SFAN_SpeedProfile2_D.sfan_speedprofile2_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile2_D : class SFAN_SpeedProfile2_D
            public static class SFAN_SpeedProfile2_D
            {
                public const string description = "Profile 2, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile2_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 30;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(2, SFAN_SpeedProfile2.sfan_speedprofile2, SFAN_SpeedProfile2_S.sfan_speedprofile2_s, SFAN_SpeedProfile2_D.sfan_speedprofile2_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV3 : class SFAN_DIV3
            public static class SFAN_DIV3
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div3 = 3;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile3_S : class SFAN_SpeedProfile3_S
            public static class SFAN_SpeedProfile3_S
            {
                public const string description = "Profile 3, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile3_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 165;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(3, SFAN_SpeedProfile3.sfan_speedprofile3, SFAN_SpeedProfile3_S.sfan_speedprofile3_s, SFAN_SpeedProfile3_D.sfan_speedprofile3_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile3 : class SFAN_SpeedProfile3
            public static class SFAN_SpeedProfile3
            {
                public const string description = "Profile 3, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile3 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(3, SFAN_SpeedProfile3.sfan_speedprofile3, SFAN_SpeedProfile3_S.sfan_speedprofile3_s, SFAN_SpeedProfile3_D.sfan_speedprofile3_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile3_D : class SFAN_SpeedProfile3_D
            public static class SFAN_SpeedProfile3_D
            {
                public const string description = "Profile 3, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile3_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 57;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(3, SFAN_SpeedProfile3.sfan_speedprofile3, SFAN_SpeedProfile3_S.sfan_speedprofile3_s, SFAN_SpeedProfile3_D.sfan_speedprofile3_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV4 : class SFAN_DIV4
            public static class SFAN_DIV4
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div4 = 4;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile4_S : class SFAN_SpeedProfile4_S
            public static class SFAN_SpeedProfile4_S
            {
                public const string description = "Profile 4, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile4_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 188;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(4, SFAN_SpeedProfile4.sfan_speedprofile4, SFAN_SpeedProfile4_S.sfan_speedprofile4_s, SFAN_SpeedProfile4_D.sfan_speedprofile4_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile4 : class SFAN_SpeedProfile4
            public static class SFAN_SpeedProfile4
            {
                public const string description = "Profile 4, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile4 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(4, SFAN_SpeedProfile4.sfan_speedprofile4, SFAN_SpeedProfile4_S.sfan_speedprofile4_s, SFAN_SpeedProfile4_D.sfan_speedprofile4_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile4_D : class SFAN_SpeedProfile4_D
            public static class SFAN_SpeedProfile4_D
            {
                public const string description = "Profile 4, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile4_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 67;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(4, SFAN_SpeedProfile4.sfan_speedprofile4, SFAN_SpeedProfile4_S.sfan_speedprofile4_s, SFAN_SpeedProfile4_D.sfan_speedprofile4_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV5 : class SFAN_DIV5
            public static class SFAN_DIV5
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div5 = 5;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile5_S : class SFAN_SpeedProfile5_S
            public static class SFAN_SpeedProfile5_S
            {
                public const string description = "Profile 5, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile5_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 213;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(5, SFAN_SpeedProfile5.sfan_speedprofile5, SFAN_SpeedProfile5_S.sfan_speedprofile5_s, SFAN_SpeedProfile5_D.sfan_speedprofile5_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile5 : class SFAN_SpeedProfile5
            public static class SFAN_SpeedProfile5
            {
                public const string description = "Profile 5, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile5 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 90;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(5, SFAN_SpeedProfile5.sfan_speedprofile5, SFAN_SpeedProfile5_S.sfan_speedprofile5_s, SFAN_SpeedProfile5_D.sfan_speedprofile5_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile5_D : class SFAN_SpeedProfile5_D
            public static class SFAN_SpeedProfile5_D
            {
                public const string description = "Profile 5, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile5_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 77;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(5, SFAN_SpeedProfile5.sfan_speedprofile5, SFAN_SpeedProfile5_S.sfan_speedprofile5_s, SFAN_SpeedProfile5_D.sfan_speedprofile5_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV6 : class SFAN_DIV6
            public static class SFAN_DIV6
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div6 = 6;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile6_S : class SFAN_SpeedProfile6_S
            public static class SFAN_SpeedProfile6_S
            {
                public const string description = "Profile 6, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile6_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 255;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(6, SFAN_SpeedProfile6.sfan_speedprofile6, SFAN_SpeedProfile6_S.sfan_speedprofile6_s, SFAN_SpeedProfile6_D.sfan_speedprofile6_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile6 : class SFAN_SpeedProfile6
            public static class SFAN_SpeedProfile6
            {
                public const string description = "Profile 6, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile6 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(6, SFAN_SpeedProfile6.sfan_speedprofile6, SFAN_SpeedProfile6_S.sfan_speedprofile6_s, SFAN_SpeedProfile6_D.sfan_speedprofile6_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile6_D : class SFAN_SpeedProfile6_D
            public static class SFAN_SpeedProfile6_D
            {
                public const string description = "Profile 6, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile6_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 87;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(6, SFAN_SpeedProfile6.sfan_speedprofile6, SFAN_SpeedProfile6_S.sfan_speedprofile6_s, SFAN_SpeedProfile6_D.sfan_speedprofile6_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfileDefault : class SFAN_SpeedProfileDefault
            public static class SFAN_SpeedProfileDefault
            {
                public const string description = "Default profile, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofiledefault = 255;
                public const string unit = "";
                public static bool initialisation = false;
            }
            #endregion

            public const int refresh_interval = 1;
            public static bool refresh()
            {
                if (!SFAN_Profile.init_done)
                {
                    SFAN_UpdateProfile(1, SFAN_SpeedProfile1.sfan_speedprofile1, SFAN_SpeedProfile1_S.sfan_speedprofile1_s, SFAN_SpeedProfile1_D.sfan_speedprofile1_d);
                    SFAN_UpdateProfile(2, SFAN_SpeedProfile2.sfan_speedprofile2, SFAN_SpeedProfile2_S.sfan_speedprofile2_s, SFAN_SpeedProfile2_D.sfan_speedprofile2_d);
                    SFAN_UpdateProfile(3, SFAN_SpeedProfile3.sfan_speedprofile3, SFAN_SpeedProfile3_S.sfan_speedprofile3_s, SFAN_SpeedProfile3_D.sfan_speedprofile3_d);
                    SFAN_UpdateProfile(4, SFAN_SpeedProfile4.sfan_speedprofile4, SFAN_SpeedProfile4_S.sfan_speedprofile4_s, SFAN_SpeedProfile4_D.sfan_speedprofile4_d);
                    SFAN_UpdateProfile(5, SFAN_SpeedProfile5.sfan_speedprofile5, SFAN_SpeedProfile5_S.sfan_speedprofile5_s, SFAN_SpeedProfile5_D.sfan_speedprofile5_d);
                    SFAN_UpdateProfile(6, SFAN_SpeedProfile6.sfan_speedprofile6, SFAN_SpeedProfile6_S.sfan_speedprofile6_s, SFAN_SpeedProfile6_D.sfan_speedprofile6_d);
                    SFAN_OnRefresh(true);
                    SFAN_Profile.init_done = true;
                }
                if (SFAN_UpdateSpeed.sfan_refreshdivider < SFAN_UpdateSpeed.sfan_updatespeed)
                {
                    SFAN_UpdateSpeed.sfan_refreshdivider++;
                    return true;
                }
                SFAN_UpdateSpeed.sfan_refreshdivider = 0;
                SFAN_OnRefresh(false);
                return true;
            }

            private static int SFAN_GetRPM(int speed)
            {
                double y = 0;
                double x = 0;
                x = (double)speed;
                if ((speed >= 0) && (speed <= 144)) y = 22.22 * x + 0;
                else if ((speed > 144) && (speed <= 165)) y = 23.81 * x + -228.57;
                else if ((speed > 165) && (speed <= 188)) y = 21.74 * x + 113.04;
                else if ((speed > 188) && (speed <= 213)) y = 16 * x + 1192;
                else if ((speed > 213) && (speed <= 255)) y = 11.9 * x + 2064.29;
                int yy = 0;
                yy = (int)y;
                if (y - yy > 0.5) yy++;
                return yy;
            }

            private static bool SFAN_OnRefresh(bool force_refresh)
            {
                int temperature_current = 0;
                int speed_current0 = 0;
                int speed_current1 = 0;
                int speed_current2 = 0;
                int profile_current = SFAN_Profile.sfan_profile;
                bool ok = false;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref temperature_current);
                temperature_current = (temperature_current - 2732) / 10;
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref speed_current0);
                ACPI.NAME.Read("_TZ.FANL", ref speed_current1);
                ACPI.NAME.Read("_TZ.FANC", ref speed_current2);
                if (force_refresh)
                {
                    for (int i = 0; i < 6; i++)
                    {
                        if (temperature_current <= SFAN_Profile.t_[i])
                        {
                            SFAN_SetCPUFanSpeed(SFAN_Profile.s_[i], SFAN_Profile.t_[i]);
                            SFAN_Profile.sfan_profile = SFAN_Profile.i_[i];
                            SFAN_Profile.sfan_profile_i = i;
                            ok = true;
                            break;
                        }
                    }
                }
                else
                {
                    for (int i = 0; i < 6; i++)
                    {
                        if (temperature_current <= SFAN_Profile.t_[i])
                        {
                            if (SFAN_Profile.sfan_profile_i > i) // spin down
                            {
                                if (temperature_current <= SFAN_Profile.d_[SFAN_Profile.sfan_profile_i])
                                {
                                    SFAN_SetCPUFanSpeed(SFAN_Profile.s_[i], SFAN_Profile.t_[i]);
                                    SFAN_Profile.sfan_profile = SFAN_Profile.i_[i];
                                    SFAN_Profile.sfan_profile_i = i;
                                }
                            }
                            else if (SFAN_Profile.sfan_profile_i < i) // spin up
                            {
                                SFAN_SetCPUFanSpeed(SFAN_Profile.s_[i], SFAN_Profile.t_[i]);
                                SFAN_Profile.sfan_profile = SFAN_Profile.i_[i];
                                SFAN_Profile.sfan_profile_i = i;
                            }
                            else if (SFAN_Profile.sfan_profile_i == i) // same profile
                            {
                                if ((speed_current0 != speed_current1) || (speed_current1 != speed_current2) || (speed_current0 != speed_current2))
                                {
                                    SFAN_SetCPUFanSpeed(SFAN_Profile.s_[i], SFAN_Profile.t_[i]);
                                    SFAN_Profile.sfan_profile = SFAN_Profile.i_[i];
                                    SFAN_Profile.sfan_profile_i = i;
                                }
                            }
                            ok = true;
                            break;
                        }
                    }
                }
                if (!ok)
                {
                    SFAN_SetCPUFanSpeed(255, 100);
                }
                SFAN_CPUTemperature.sfan_cputemperature = temperature_current;
                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed, int maxtemperature)
            {
                ACPI.NAME.Write("_TZ.FANL", speed);
                ACPI.NAME.Write("_TZ.FANC", speed);
                ACPI.NAME.Write("_TZ.PLCY", 0);
                int[] inArg = { 0, 0 };
                inArg[0] = maxtemperature + 5; // Higher temperature limit
                inArg[1] = 0;  // Lower temperature limit
                int[] outArg = { 0 };
                ACPI.METHOD.Call("_TZ.WTML", inArg, 2, ref outArg, 0);
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                ACPI.METHOD.Call("_TZ.UMIT");
                SFAN_WARNING.sfan_warning = maxtemperature + 5;
                SFAN_FanSpeed.sfan_fanspeed = SFAN_GetRPM(speed);
                return true;
            }

            private static bool SFAN_UpdateProfile(int profile, int maxtemperature, int speed, int mintemperature)
            {
                int idx = 0;
                for (int i = 0; i < 6; i++)
                {
                    if (SFAN_Profile.i_[i] == profile)
                    {
                        idx = i;
                        break;
                    }
                }
                SFAN_Profile.t_[idx] = maxtemperature;
                SFAN_Profile.s_[idx] = speed;
                SFAN_Profile.d_[idx] = mintemperature;
                int tmp;
                for (int i = 1; i < 6; i++)
                {
                    for (int j = 5; j > 0; j--)
                    {
                        if (SFAN_Profile.t_[j - 1] > SFAN_Profile.t_[j])
                        {
                            tmp = SFAN_Profile.t_[j];
                            SFAN_Profile.t_[j] = SFAN_Profile.t_[j - 1];
                            SFAN_Profile.t_[j - 1] = tmp;
                            tmp = SFAN_Profile.s_[j];
                            SFAN_Profile.s_[j] = SFAN_Profile.s_[j - 1];
                            SFAN_Profile.s_[j - 1] = tmp;
                            tmp = SFAN_Profile.i_[j];
                            SFAN_Profile.i_[j] = SFAN_Profile.i_[j - 1];
                            SFAN_Profile.i_[j - 1] = tmp;
                            tmp = SFAN_Profile.d_[j];
                            SFAN_Profile.d_[j] = SFAN_Profile.d_[j - 1];
                            SFAN_Profile.d_[j - 1] = tmp;
                        }
                    }
                }
                if (SFAN_Profile.init_done) SFAN_OnRefresh(true);
                return true;
            }
        }
        #endregion
    }
    #endregion

    #region Notebook Asus A8JP : class A8JP
    //
    // Class author: t6m4n232v57@gmx.li
    // Version: 15.04.2007
    // Bios Version: 209
    //
    public static class A8JP
    {
        public const string author = "t6m4n232v57@gmx.li";

        #region Class for Asus A8JP LCD Brightness control : class BRIGHTNESS   // The class must have the name BRIGHTNESS
        public static class BRIGHTNESS
        {
            public const string description = "LCD-Brightness Control";
            public const bool default_enabled = false;
            public const int icon = 1;    // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public const int minimum_brightness_level = 0;    //
            public const int maximum_brightness_level = 15;   // to detect brightness change by keystroke
            public const int brightness_level_step = 1;   //

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            public static class BRIGHTNESS_LEVEL
            {
                public const string description = "LCD brightness level (0-15)";
                public const bool nhc_visible = true;
                public static int brightness_level = 0;
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 15;
                    public const int nhc_default_value = 15;
                    public static bool nhc_on_write()
                    {
                        ACPI.METHOD.SetValue("_SB.ATKD.SPLV", BRIGHTNESS_LEVEL.brightness_level);
                        return true;
                    }
                }
            }
            #endregion

            public static bool set_brightness(int new_level)
            {
                ACPI.METHOD.SetValue("_SB.ATKD.SPLV", BRIGHTNESS_LEVEL.brightness_level);
                return true;
            }

            public static bool get_brightness(ref int level)
            {
                bool result = true;
                ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);   // get current brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        #endregion

        #region Class for Asus A8JP SFAN control : class SFAN
        public static class SFAN
        {
            public const string description = "ACPI Intelligent RPM/°C Fan Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for SFAN_CPUTemperature : class SFAN_CPUTemperature
            public static class SFAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for SFAN_FanSpeed : class SFAN_FanSpeed
            public static class SFAN_FanSpeed
            {
                public const string description = "Current fan speed (80-255, 0=off)";
                public const bool nhc_visible = true;
                public static int sfan_fanspeed = 0;
                public const string unit = "";
                public static int sfan_refreshdivider = 0;
            }
            #endregion

            #region Value class for SFAN_UpdateSpeed : class SFAN_UpdateSpeed
            public static class SFAN_UpdateSpeed
            {
                public const string description = "Update fan speed every";
                public const bool nhc_visible = true;
                public static int sfan_updatespeed = 0;
                public const string unit = " second(s)";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 1;
                    public const int nhc_maximum_value = 10;
                    public const int nhc_default_value = 3;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            #region Value class for SFAN_MaxTemperature : class SFAN_MaxTemperature
            public static class SFAN_MaxTemperature
            {
                public const string description = "Maximum fan speed CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_maxtemperature = 0;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 65;
                    public const int nhc_maximum_value = 85;
                    public const int nhc_default_value = 75;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            #region Value class for SFAN_MinTemperature : class SFAN_MinTemperature
            public static class SFAN_MinTemperature
            {
                public const string description = "Fan start CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_mintemperature = 0;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 35;
                    public const int nhc_maximum_value = 55;
                    public const int nhc_default_value = 45;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            public static bool refresh()
            {
                if (SFAN_FanSpeed.sfan_refreshdivider + 1 < SFAN_UpdateSpeed.sfan_updatespeed)    // delay-loop
                {
                    SFAN_FanSpeed.sfan_refreshdivider++;
                    return true;
                }
                SFAN_FanSpeed.sfan_refreshdivider = 0;
                int temperature_current = 0;
                int speed_current = 0;
                int temperature_min = SFAN_MinTemperature.sfan_mintemperature;
                int temperature_max = SFAN_MaxTemperature.sfan_maxtemperature;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref temperature_current);
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref speed_current);
                temperature_current = (temperature_current - 2732) / 10;    // conversion to celsius
                int fan_speed = (temperature_current - temperature_min) * 175 / (temperature_max - temperature_min) + 80;   // calculating fan_speed
                if (fan_speed > 79)   // fan starts spinning only > 75
                {
                    if (fan_speed != speed_current) SFAN_SetCPUFanSpeed(fan_speed);   // to avoid useless updating
                }
                else
                {
                    if (speed_current != 0)   // to avoid useless updating
                    {
                        SFAN_SetCPUFanSpeed(0);
                        ACPI.NAME.Write("_TZ.PLCY", 1);
                    }
                }
                SFAN_CPUTemperature.sfan_cputemperature = temperature_current;
                SFAN_FanSpeed.sfan_fanspeed = speed_current;
                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed)    // the speed-setting-thing
            {
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                ACPI.NAME.Write("_TZ.PLCY", 0);
                return true;
            }
        }
        #endregion

        #region Class for Asus A8JP FAN control : class FAN
        public static class FAN
        {
            public const string description = "ACPI Manual Fan Control";
            public const bool default_enabled = false;
            public const int icon = 2;

            #region Value class for FAN_CPUTemperature : class FAN_CPUTemperature
            public static class FAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int fan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for FAN_FanSpeed : class FAN_FanSpeed
            public static class FAN_FanSpeed
            {
                public const string description = "Current fan speed (0-255, 0=off)";
                public const bool nhc_visible = true;
                public static int fan_fanspeed = 0;
                public const string unit = "";
            }
            #endregion

            public static class FAN_ON_OFF
            {
                public const string description = "Fan switch (on/off)";
                public const bool nhc_visible = true;
                public static int fan_on_off = 0;
                public const string unit = "off|on";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 1;
                    public const int nhc_default_value = 1;
                    public static bool initialisation = false;
                    public static bool nhc_on_write()
                    {
                        if (!initialisation)    // avoids "wtf, it says 'off' but it's on?"
                        {
                            int a = 0;
                            ACPI.NAME.Read("_TZ.PLCY", ref a);
                            FAN_ON_OFF.fan_on_off = ((a == 0) ? 1 : 0);
                            initialisation = true;
                            return true;
                        }

                        if (fan_on_off != 0)    // on and off
                        {
                            SFAN_SetCPUFanSpeed(FAN_SPEED.fan_speed);
                            ACPI.NAME.Write("_TZ.PLCY", 0);
                        }
                        else
                        {
                            SFAN_SetCPUFanSpeed(0);
                            ACPI.NAME.Write("_TZ.PLCY", 1);
                        }
                        return true;
                    }
                }
            }
            public static class FAN_SPEED
            {
                public const string description = "Update fan speed to (0 to 255)";
                public const bool nhc_visible = true;
                public static int fan_speed = 0;
                public const string unit = "";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 167;

                    public static bool nhc_on_write()
                    {
                        int is_fan_off = 0;
                        ACPI.NAME.Read("_TZ.PLCY", ref is_fan_off);
                        if (is_fan_off == 0)    // only has effect while fan is "switched" on
                        {
                            SFAN_SetCPUFanSpeed(fan_speed);
                            return true;
                        }
                        return true;
                    }
                }
            }

            public static bool refresh()
            {
                int cpu_current = 0;    // updating temp & rpm
                int fan_current = 0;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref cpu_current);
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref fan_current);
                FAN_CPUTemperature.fan_cputemperature = (cpu_current - 2732) / 10;
                FAN_FanSpeed.fan_fanspeed = fan_current;
                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed)    // the speed-setting-thing
            {
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                return true;
            }
        }
        #endregion
    }
    #endregion

    #region Notebook Asus A8JS : class A8JS
    //
    // Class author: t6m4n232v57@gmx.li
    // Version: 15.04.2007
    // Bios Version: 211
    //
    public static class A8JS
    {
        public const string author = "t6m4n232v57@gmx.li";

        #region Class for Asus A8JS LCD Brightness control : class BRIGHTNESS   // The class must have the name BRIGHTNESS
        public static class BRIGHTNESS
        {
            public const string description = "LCD-Brightness Control";
            public const bool default_enabled = false;
            public const int icon = 1;    // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public const int minimum_brightness_level = 0;    //
            public const int maximum_brightness_level = 15;   // to detect brightness change by keystroke
            public const int brightness_level_step = 1;   //

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            public static class BRIGHTNESS_LEVEL
            {
                public const string description = "LCD brightness level (0-15)";
                public const bool nhc_visible = true;
                public static int brightness_level = 0;
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 15;
                    public const int nhc_default_value = 15;
                    public static bool nhc_on_write()
                    {
                        ACPI.METHOD.SetValue("_SB.ATKD.SPLV", BRIGHTNESS_LEVEL.brightness_level);
                        return true;
                    }
                }
            }
            #endregion

            public static bool set_brightness(int new_level)
            {
                ACPI.METHOD.SetValue("_SB.ATKD.SPLV", BRIGHTNESS_LEVEL.brightness_level);
                return true;
            }

            public static bool get_brightness(ref int level)
            {
                bool result = true;
                ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);   // get current brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        #endregion

        #region Class for Asus A8JS SFAN control : class SFAN
        public static class SFAN
        {
            public const string description = "ACPI Intelligent RPM/°C Fan Control";
            public const bool default_enabled = true;
            public const int icon = 2;
            #region Value class for SFAN_CPUTemperature : class SFAN_CPUTemperature
            public static class SFAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for SFAN_FanSpeed : class SFAN_FanSpeed
            public static class SFAN_FanSpeed
            {
                public const string description = "Current fan speed (80-255, 0=off)";
                public const bool nhc_visible = true;
                public static int sfan_fanspeed = 0;
                public const string unit = "";
                public static int sfan_refreshdivider = 0;
            }
            #endregion

            #region Value class for SFAN_UpdateSpeed : class SFAN_UpdateSpeed
            public static class SFAN_UpdateSpeed
            {
                public const string description = "Update fan speed every";
                public const bool nhc_visible = true;
                public static int sfan_updatespeed = 0;
                public const string unit = " second(s)";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 1;
                    public const int nhc_maximum_value = 10;
                    public const int nhc_default_value = 3;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            #region Value class for SFAN_MaxTemperature : class SFAN_MaxTemperature
            public static class SFAN_MaxTemperature
            {
                public const string description = "Maximum fan speed CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_maxtemperature = 0;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 65;
                    public const int nhc_maximum_value = 85;
                    public const int nhc_default_value = 75;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            #region Value class for SFAN_MinTemperature : class SFAN_MinTemperature
            public static class SFAN_MinTemperature
            {
                public const string description = "Fan start CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_mintemperature = 0;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 35;
                    public const int nhc_maximum_value = 55;
                    public const int nhc_default_value = 45;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            public static bool refresh()
            {
                if (SFAN_FanSpeed.sfan_refreshdivider + 1 < SFAN_UpdateSpeed.sfan_updatespeed)    // delay-loop
                {
                    SFAN_FanSpeed.sfan_refreshdivider++;
                    return true;
                }
                SFAN_FanSpeed.sfan_refreshdivider = 0;
                int temperature_current = 0;
                int speed_current = 0;
                int temperature_min = SFAN_MinTemperature.sfan_mintemperature;
                int temperature_max = SFAN_MaxTemperature.sfan_maxtemperature;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref temperature_current);
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref speed_current);
                temperature_current = (temperature_current - 2732) / 10;    // conversion to celsius
                int fan_speed = (temperature_current - temperature_min) * 175 / (temperature_max - temperature_min) + 80;   // calculating fan_speed
                if (fan_speed > 79)   // fan starts spinning only > 75
                {
                    if (fan_speed != speed_current) SFAN_SetCPUFanSpeed(fan_speed);   // to avoid useless updating
                }
                else
                {
                    if (speed_current != 0)   // to avoid useless updating
                    {
                        SFAN_SetCPUFanSpeed(0);
                        ACPI.NAME.Write("_TZ.PLCY", 1);
                    }
                }
                SFAN_CPUTemperature.sfan_cputemperature = temperature_current;
                SFAN_FanSpeed.sfan_fanspeed = speed_current;
                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed)    // the speed-setting-thing
            {
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                ACPI.NAME.Write("_TZ.PLCY", 0);
                return true;
            }
        }
        #endregion

        #region Class for Asus A8JS FAN control : class FAN
        public static class FAN
        {
            public const string description = "ACPI Manual Fan Control";
            public const bool default_enabled = false;
            public const int icon = 2;
            #region Value class for FAN_CPUTemperature : class FAN_CPUTemperature
            public static class FAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int fan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for FAN_FanSpeed : class FAN_FanSpeed
            public static class FAN_FanSpeed
            {
                public const string description = "Current fan speed (0-255, 0=off)";
                public const bool nhc_visible = true;
                public static int fan_fanspeed = 0;
                public const string unit = "";
            }
            #endregion

            public static class FAN_ON_OFF
            {
                public const string description = "Fan switch (on/off)";
                public const bool nhc_visible = true;
                public static int fan_on_off = 0;
                public const string unit = "off|on";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 1;
                    public const int nhc_default_value = 1;
                    public static bool initialisation = false;
                    public static bool nhc_on_write()
                    {
                        if (!initialisation)    // avoids "wtf, it says 'off' but it's on?"
                        {
                            int a = 0;
                            ACPI.NAME.Read("_TZ.PLCY", ref a);
                            FAN_ON_OFF.fan_on_off = ((a == 0) ? 1 : 0);
                            initialisation = true;
                            return true;
                        }

                        if (fan_on_off != 0)    // on and off
                        {
                            SFAN_SetCPUFanSpeed(FAN_SPEED.fan_speed);
                            ACPI.NAME.Write("_TZ.PLCY", 0);
                        }
                        else
                        {
                            SFAN_SetCPUFanSpeed(0);
                            ACPI.NAME.Write("_TZ.PLCY", 1);
                        }
                        return true;
                    }
                }
            }
            public static class FAN_SPEED
            {
                public const string description = "Update fan speed to (0 to 255)";
                public const bool nhc_visible = true;
                public static int fan_speed = 0;
                public const string unit = "";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 167;

                    public static bool nhc_on_write()
                    {
                        int is_fan_off = 0;
                        ACPI.NAME.Read("_TZ.PLCY", ref is_fan_off);
                        if (is_fan_off == 0)    // only has effect while fan is "switched" on
                        {
                            SFAN_SetCPUFanSpeed(fan_speed);
                            return true;
                        }
                        return true;
                    }
                }
            }

            public static bool refresh()
            {
                int cpu_current = 0;    // updating temp & rpm
                int fan_current = 0;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref cpu_current);
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref fan_current);
                FAN_CPUTemperature.fan_cputemperature = (cpu_current - 2732) / 10;
                FAN_FanSpeed.fan_fanspeed = fan_current;
                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed)    // the speed-setting-thing
            {
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                return true;
            }
        }
        #endregion
    }
    #endregion

    #region Notebook Asus F3JA : class F3JA
    //
    // Fan control for Asus F3JA
    // User class by Martin N°ssing
    // Edited by Rene Hoffmann
    // Edited on December 27th, 2006, by Erwin Mayer, student at the French National Telecommunications Institute (erwin.mayer@int-evry.fr)
    //
    // The Fan speed will be controlled by the _SB.PCI0.SBRG.EC0.WMFN register in the Embedded Controller.
    // WMFN is a 8 bits register. The MSB (Bit 7) controls the fan control method:
    // manual = 0, automatic (default)= 1. If it is automatic, all the 8 bits should be on 1. Bits positions are said from the right to the left and start at 0.
    // Value 0xFF: automatic fan speed
    // The next 7 Bits (Bit 6 - 0) set the fan speed (only when Bit 7 is 0):
    // Values 0x00 to 0xEF: fan speeds in ascending order
    // [to be verified] "value 0x0 to 0x5: fan is off and from value 0x5 to 0xF: fan speeds in ascending order"
    //
    // The Fan control of this class has 6 "temperature on values" with the corresponding fan speed 0-12.
    // "FAN 0 speed" means the fan speed seated on temperatures under "FAN ON 1 LEVEL".
    // If the fan speed is set to 12, the program goes in automatic mode and allows to drive the fan very fast. This is recommended for the highest on_temp level so that the computer doesn't shut down because of an overheating.
    // The control class also allows to set 5 "temperature off values" to realize a hysteresis.
    // The on_temp must be in ascendent order, while the off_temp must be in descendent order! The class does not check this. If it is not, which is the case for some of the default off_temp values chosen here, NHC will ignore the faulty thresholds until the actual temperature reaches a correct (ascending or descending) one.
    // The class is tested, but feel free to fix or expand the functionality ! More information about programming classes is available on NHC website.
    //
    // Updates:
    // on_temp[6] was defined in init() (Fan did not enter speed level 5 since init() did not define on_temp[6])
    // added WMFN  (0xFF) for fan_x_speed set to 12 (At least the Asus F3JA automatic fan control only sets max fan speed with WMFN(0xFF))
    // Inactivated Brightness control (not tested)
    // Another speed level implemented for highest fan speed (12)
    // fan speed 10 - 12 are temperature controled with different maximum fan speeds
    //
    // Tested with Asus F3JA Bios Version 207, NHC 2.0 Pre-04
    //
    public static class F3JA
    {
        public const string author = "Martin N°ssing, Rene Hoffmann, Erwin Mayer";

        #region Class for Asus F3JA LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = false;                              // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return true;//ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = true;//ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        //
        #endregion

        #region Class for Asus F3JA FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            // Global variables for FAN control
            public static int actual_level = -1;
            public const int refresh_interval = 1;
            public const int MAX_SPEED_NR = 6;

            // Global fan control data
            public static int[] speed = new int[MAX_SPEED_NR + 1];
            public static int[] on_temp = new int[MAX_SPEED_NR + 2];
            public static int[] off_temp = new int[MAX_SPEED_NR + 2];

            #region Value class for FAN_0_SPEED : class FAN_0_SPEED
            //
            public static class FAN_0_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 0 speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_0_speed = 0;                              // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 0;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[0] = fan_0_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_1_SPEED : class FAN_1_SPEED
            //
            public static class FAN_1_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 1 speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_1_speed = 1;                              // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 1;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[1] = fan_1_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_2_SPEED : class FAN_2_SPEED
            //
            public static class FAN_2_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 2 speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_2_speed = 3;                           // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 3;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[2] = fan_2_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_3_SPEED : class FAN_3_SPEED
            //
            public static class FAN_3_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 3 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_3_speed = 6;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 6;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[3] = fan_3_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_4_SPEED : class FAN_4_SPEED
            //
            public static class FAN_4_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 4 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_4_speed = 9;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 9;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[4] = fan_4_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_5_SPEED : class FAN_5_SPEED
            //
            public static class FAN_5_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 5 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_5_speed = 11;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 11;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[5] = fan_5_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_6_SPEED : class FAN_6_SPEED
            //
            public static class FAN_6_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 6 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_6_speed = 12;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 12;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[6] = fan_6_speed;
                        return true;
                    }
                }
            }
            //
            #endregion


            #region  Value class for LEVEL_1_ON : class LEVEL_1_ON
            //
            public static class LEVEL_1_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 1 level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_1_on = 37;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 37;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[1] = level_1_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_2_ON : class LEVEL_2_ON
            //
            public static class LEVEL_2_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 2 level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_2_on = 42;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 42;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[2] = level_2_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_3_ON : class LEVEL_3_ON
            //
            public static class LEVEL_3_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 3 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_3_on = 56;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 56;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[3] = level_3_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_4_ON : class LEVEL_4_ON
            //
            public static class LEVEL_4_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 4 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_4_on = 57;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 36;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 57;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[4] = level_4_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_5_ON : class LEVEL_5_ON
            //
            public static class LEVEL_5_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 5 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_5_on = 58;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 58;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[5] = level_5_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_6_ON : class LEVEL_6_ON
            //
            public static class LEVEL_6_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 6 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_6_on = 68;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 68;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[6] = level_6_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_1_OFF : class LEVEL_1_OFF
            //
            public static class LEVEL_1_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 1 level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_1_off = 34;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 34;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[1] = level_1_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_2_OFF : class LEVEL_2_OFF
            //
            public static class LEVEL_2_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 2 level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_2_off = 38;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 38;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[2] = level_2_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_3_OFF : class LEVEL_3_OFF
            //
            public static class LEVEL_3_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 3 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_3_off = 48;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 48;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[3] = level_3_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_4_OFF : class LEVEL_4_OFF
            //
            public static class LEVEL_4_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 4 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_4_off = 45;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 36;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[4] = level_4_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_5_OFF : class LEVEL_5_OFF
            //
            public static class LEVEL_5_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 5 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_5_off = 43;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 43;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[5] = level_5_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_6_OFF : class LEVEL_6_OFF
            //
            public static class LEVEL_6_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 6 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_6_off = 60;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[6] = level_6_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            public static bool check_for_higher_speed_level(int start_index)
            {
                int i = start_index;
                bool result = false;

                while (!result && i <= MAX_SPEED_NR)
                {
                    result = result || (speed[i] == actual_level);
                    i++;
                }
                return result;
            }

            public static bool init()
            {
                speed[0] = FAN_0_SPEED.fan_0_speed;
                speed[1] = FAN_1_SPEED.fan_1_speed;
                speed[2] = FAN_2_SPEED.fan_2_speed;
                speed[3] = FAN_3_SPEED.fan_3_speed;
                speed[4] = FAN_4_SPEED.fan_4_speed;
                speed[5] = FAN_5_SPEED.fan_5_speed;
                speed[6] = FAN_6_SPEED.fan_6_speed;

                on_temp[0] = 0;
                on_temp[1] = LEVEL_1_ON.level_1_on;
                on_temp[2] = LEVEL_2_ON.level_2_on;
                on_temp[3] = LEVEL_3_ON.level_3_on;
                on_temp[4] = LEVEL_4_ON.level_4_on;
                on_temp[5] = LEVEL_5_ON.level_5_on;
                on_temp[6] = LEVEL_6_ON.level_6_on;
                on_temp[7] = 200;

                off_temp[0] = 0;
                off_temp[1] = LEVEL_1_OFF.level_1_off;
                off_temp[2] = LEVEL_2_OFF.level_2_off;
                off_temp[3] = LEVEL_3_OFF.level_3_off;
                off_temp[4] = LEVEL_4_OFF.level_4_off;
                off_temp[5] = LEVEL_5_OFF.level_5_off;
                off_temp[6] = LEVEL_6_OFF.level_6_off;
                off_temp[7] = 200;

                return true;
            }

            public static bool refresh()
            {
                bool result = false;
                bool find = false;
                bool previous_level = false;
                int temp = 0;
                int i = 0;

                // read actual CPU temp
                result = ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.ECPU", ref temp);

                while (!find && (i <= MAX_SPEED_NR))
                {
                    // Check, if the previous temp was higher then the actual
                    previous_level = check_for_higher_speed_level(i + 1);

                    // Search the temp window for the actual temp
                    // If the previous temp was lower, than the upper temp boundary is the normal "temp on" value of the next window
                    // If the previous temp was higher, than the upper temp boundary is temp off value of the next window

                    if ((temp >= on_temp[i]) &&
                         (((temp < on_temp[i + 1]) && !previous_level) ||
                          ((temp <= off_temp[i + 1]) && previous_level)))
                    {
                        // If just the right fan speed? Than, no need to set another time
                        if (speed[i] != actual_level)
                        {
                            //speed 1-9 is manually set, 10 - 12 are temperature controled with different max fan speeds
                            switch (speed[i])
                            {
                                case 10:
                                    result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", (0x8F));
                                    break;

                                case 11:
                                    result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", (0x9F));
                                    break;

                                case 12:
                                    result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", (0xFF));
                                    break;

                                default:
                                    result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", ((speed[i] + 6) << 3) | 0x07);
                                    break;
                            }
                            // The | 0x07 is not really justified, but it is not that important... If you put | 0x00 instead, then the fan will really be off !
                            actual_level = speed[i];
                        }
                        // Break the search
                        find = true;
                    }
                    i++;
                }

                return result;
            }


        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Asus F3JC : class F3JC
    //
    // Fan control for Asus F3Jc
    // User class by Martin N°ssing
    //
    // The Fan speed will be controlled by the _SB.PCI0.SBRG.EC0.WMFN register in the Embedded Controller.
    // WMFN is a 8 bit register. The MSB (Bit 7) control the method of fan control:
    //  manual = 0, automatic (default)= 1
    // The next 4 Bit (Bit 6 - 2) sets the fan speed (only when Bit 7 is 0):
    //  value 0x0 to 0x5: fan is off
    //  from value 0x5 to 0xF: fan speeds in ascending order
    //  The only problem is that a maximum fan speed set in WMFN(0xF) is not the realy maximum speed of the fan. In automatic mode,
    //  the fan can drive the motor more faster on higher tempertures!
    //
    // The Fan control of this class has 5 "temperatures on values" with the corresponding fan speed 0-9.
    // "FAN 0 speed" means the fan speed seated on temperatures under "FAN ON 1 LEVEL".
    // If the fan speed is set to 10, the program goes in automatic mode and allows to drive the fan very fast
    // (a little workaround for the problem mentioned above, but only for the appropriate temperature window).
    // The control class allows also to set 5 "temperatures off values" to realize a hysteresis.
    // The temperatures must are in ascendent order! The class not check this.
    // The class is not realy tested, please feel free to fix or expand the functionality
    //
    //****NOTE!!:IF YOU TURN YOUR FAN OFF MANUALLY, OVERHEATING MAY OCCUR.!!****
    //
    public static class F3JC
    {
        public const string author = "Martin N°ssing";

        #region Class for Asus F3JC LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = false;                              // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return true;//ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = true;//ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        //
        #endregion

        #region Class for Asus F3JC FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            // Global variables for FAN control
            public static int actual_level = -1;
            public const int refresh_interval = 1;
            public const int MAX_SPEED_NR = 5;

            // Global fan control data
            public static int[] speed = new int[MAX_SPEED_NR + 1];
            public static int[] on_temp = new int[MAX_SPEED_NR + 2];
            public static int[] off_temp = new int[MAX_SPEED_NR + 2];

            #region Value class for FAN_0_SPEED : class FAN_0_SPEED
            //
            public static class FAN_0_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 0 speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_0_speed = 0;                              // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 0;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[0] = fan_0_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_1_SPEED : class FAN_1_SPEED
            //
            public static class FAN_1_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 1 speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_1_speed = 1;                              // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 1;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[1] = fan_1_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_2_SPEED : class FAN_2_SPEED
            //
            public static class FAN_2_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 2 speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_2_speed = 3;                           // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 3;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[2] = fan_2_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_3_SPEED : class FAN_3_SPEED
            //
            public static class FAN_3_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 3 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_3_speed = 6;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 6;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[3] = fan_3_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_4_SPEED : class FAN_4_SPEED
            //
            public static class FAN_4_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 4 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_4_speed = 9;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 9;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[4] = fan_4_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_5_SPEED : class FAN_5_SPEED
            //
            public static class FAN_5_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 5 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_5_speed = 9;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 10;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[5] = fan_5_speed;
                        return true;
                    }
                }
            }
            //
            #endregion



            #region  Value class for LEVEL_1_ON : class LEVEL_1_ON
            //
            public static class LEVEL_1_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 1 level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_1_on = 45;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[1] = level_1_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_2_ON : class LEVEL_2_ON
            //
            public static class LEVEL_2_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 2 level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_2_on = 50;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[2] = level_2_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_3_ON : class LEVEL_3_ON
            //
            public static class LEVEL_3_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 3 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_3_on = 55;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 55;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[3] = level_3_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_4_ON : class LEVEL_4_ON
            //
            public static class LEVEL_4_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 4 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_4_on = 60;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 36;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[4] = level_4_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_5_ON : class LEVEL_5_ON
            //
            public static class LEVEL_5_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 5 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_5_on = 65;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[5] = level_5_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_1_OFF : class LEVEL_1_OFF
            //
            public static class LEVEL_1_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 1 level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_1_off = 43;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 43;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[1] = level_1_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_2_OFF : class LEVEL_2_OFF
            //
            public static class LEVEL_2_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 2 level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_2_off = 48;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 48;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[2] = level_2_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_3_OFF : class LEVEL_3_OFF
            //
            public static class LEVEL_3_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 3 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_3_off = 53;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 53;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[3] = level_3_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_4_OFF : class LEVEL_4_OFF
            //
            public static class LEVEL_4_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 4 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_4_off = 58;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 36;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 58;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[4] = level_4_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_5_OFF : class LEVEL_5_OFF
            //
            public static class LEVEL_5_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 5 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_5_off = 63;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 63;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[5] = level_5_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            public static bool check_for_higher_speed_level(int start_index)
            {
                int i = start_index;
                bool result = false;

                while (!result && i <= MAX_SPEED_NR)
                {
                    result = result || (speed[i] == actual_level);
                    i++;
                }
                return result;
            }

            public static bool init()
            {
                speed[0] = FAN_0_SPEED.fan_0_speed;
                speed[1] = FAN_1_SPEED.fan_1_speed;
                speed[2] = FAN_2_SPEED.fan_2_speed;
                speed[3] = FAN_3_SPEED.fan_3_speed;
                speed[4] = FAN_4_SPEED.fan_4_speed;
                speed[5] = FAN_5_SPEED.fan_5_speed;

                on_temp[0] = 0;
                on_temp[1] = LEVEL_1_ON.level_1_on;
                on_temp[2] = LEVEL_2_ON.level_2_on;
                on_temp[3] = LEVEL_3_ON.level_3_on;
                on_temp[4] = LEVEL_4_ON.level_4_on;
                on_temp[5] = LEVEL_5_ON.level_5_on;
                off_temp[6] = 200;

                off_temp[0] = 0;
                off_temp[1] = LEVEL_1_OFF.level_1_off;
                off_temp[2] = LEVEL_2_OFF.level_2_off;
                off_temp[3] = LEVEL_3_OFF.level_3_off;
                off_temp[4] = LEVEL_4_OFF.level_4_off;
                off_temp[5] = LEVEL_5_OFF.level_5_off;
                off_temp[6] = 200;

                return true;
            }

            public static bool refresh()
            {
                bool result = false;
                bool find = false;
                bool previous_level = false;
                int temp = 0;
                int i = 0;

                // read actual CPU temp
                result = ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.ECPU", ref temp);

                while (!find && (i <= MAX_SPEED_NR))
                {
                    // Check, if the previous temp was higher then the actual
                    previous_level = check_for_higher_speed_level(i + 1);

                    // Search the temp window for the actual temp
                    // If the previous temp was lower, than the upper temp boundary is the normal "temp on" value of the next window
                    // If the previous temp was higher, than the upper temp boundary is temp off value of the next window

                    if ((temp >= on_temp[i]) &&
                         (((temp < on_temp[i + 1]) && !previous_level) ||
                          ((temp <= off_temp[i + 1]) && previous_level)))
                    {
                        // If just the right fan speed? Than, no need to set another time
                        if (speed[i] != actual_level)
                        {
                            result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", ((speed[i] + 6) << 3) | 0x07);
                            actual_level = speed[i];
                        }
                        // Break the search
                        find = true;
                    }
                    i++;
                }

                return result;
            }


        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Asus F3JM : class F3JM
    //
    // Fan control for Asus F3JM
    // User class by Martin N°ssing
    // Edited by Rene Hoffmann
    // Edited on December 27th, 2006, by Erwin Mayer, student at the French National Telecommunications Institute (erwin.mayer@int-evry.fr)
    //
    // The Fan speed will be controlled by the _SB.PCI0.SBRG.EC0.WMFN register in the Embedded Controller.
    // WMFN is a 8 bits register. The MSB (Bit 7) controls the fan control method:
    // manual = 0, automatic (default)= 1. If it is automatic, all the 8 bits should be on 1. Bits positions are said from the right to the left and start at 0.
    // Value 0xFF: automatic fan speed
    // The next 7 Bits (Bit 6 - 0) set the fan speed (only when Bit 7 is 0):
    // Values 0x00 to 0xEF: fan speeds in ascending order
    // [to be verified] "value 0x0 to 0x5: fan is off and from value 0x5 to 0xF: fan speeds in ascending order"
    //
    // The Fan control of this class has 6 "temperature on values" with the corresponding fan speed 0-12.
    // "FAN 0 speed" means the fan speed seated on temperatures under "FAN ON 1 LEVEL".
    // If the fan speed is set to 12, the program goes in automatic mode and allows to drive the fan very fast. This is recommended for the highest on_temp level so that the computer doesn't shut down because of an overheating.
    // The control class also allows to set 5 "temperature off values" to realize a hysteresis.
    // The on_temp must be in ascendent order, while the off_temp must be in descendent order! The class does not check this. If it is not, which is the case for some of the default off_temp values chosen here, NHC will ignore the faulty thresholds until the actual temperature reaches a correct (ascending or descending) one.
    // The class is tested, but feel free to fix or expand the functionality ! More information about programming classes is available on NHC website.
    //
    // Updates:
    // on_temp[6] was defined in init() (Fan did not enter speed level 5 since init() did not define on_temp[6])
    // added WMFN  (0xFF) for fan_x_speed set to 12 (At least the Asus F3JM automatic fan control only sets max fan speed with WMFN(0xFF))
    // Inactivated Brightness control (not tested)
    // Another speed level implemented for highest fan speed (12)
    // fan speed 10 - 12 are temperature controled with different maximum fan speeds
    //
    // Tested with Asus F3JM Bios Version 207, NHC 2.0 Pre-04
    //
    //****NOTE!!:IF YOU TURN YOUR FAN OFF MANUALLY, OVERHEATING MAY OCCUR.!!****
    //
    public static class F3JM
    {
        public const string author = "Martin N°ssing, Rene Hoffmann, Erwin Mayer";

        #region Class for Asus F3JM LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = false;                              // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return true;//ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = true;//ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        //
        #endregion

        #region Class for Asus F3JM FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            // Global variables for FAN control
            public static int actual_level = -1;
            public const int refresh_interval = 1;
            public const int MAX_SPEED_NR = 6;

            // Global fan control data
            public static int[] speed = new int[MAX_SPEED_NR + 1];
            public static int[] on_temp = new int[MAX_SPEED_NR + 2];
            public static int[] off_temp = new int[MAX_SPEED_NR + 2];

            #region Value class for FAN_0_SPEED : class FAN_0_SPEED
            //
            public static class FAN_0_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 0 speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_0_speed = 0;                              // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 0;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[0] = fan_0_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_1_SPEED : class FAN_1_SPEED
            //
            public static class FAN_1_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 1 speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_1_speed = 1;                              // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 1;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[1] = fan_1_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_2_SPEED : class FAN_2_SPEED
            //
            public static class FAN_2_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 2 speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_2_speed = 3;                           // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 3;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[2] = fan_2_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_3_SPEED : class FAN_3_SPEED
            //
            public static class FAN_3_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 3 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_3_speed = 6;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 6;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[3] = fan_3_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_4_SPEED : class FAN_4_SPEED
            //
            public static class FAN_4_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 4 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_4_speed = 9;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 9;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[4] = fan_4_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_5_SPEED : class FAN_5_SPEED
            //
            public static class FAN_5_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 5 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_5_speed = 11;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 11;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[5] = fan_5_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_6_SPEED : class FAN_6_SPEED
            //
            public static class FAN_6_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 6 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_6_speed = 12;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 12;                       // maximum input value
                    public const int nhc_default_value = 12;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[6] = fan_6_speed;
                        return true;
                    }
                }
            }
            //
            #endregion



            #region  Value class for LEVEL_1_ON : class LEVEL_1_ON
            //
            public static class LEVEL_1_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 1 level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_1_on = 37;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 37;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[1] = level_1_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_2_ON : class LEVEL_2_ON
            //
            public static class LEVEL_2_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 2 level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_2_on = 42;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 42;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[2] = level_2_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_3_ON : class LEVEL_3_ON
            //
            public static class LEVEL_3_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 3 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_3_on = 56;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 56;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[3] = level_3_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_4_ON : class LEVEL_4_ON
            //
            public static class LEVEL_4_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 4 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_4_on = 57;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 36;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 57;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[4] = level_4_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_5_ON : class LEVEL_5_ON
            //
            public static class LEVEL_5_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 5 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_5_on = 58;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 58;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[5] = level_5_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_6_ON : class LEVEL_6_ON
            //
            public static class LEVEL_6_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 6 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_6_on = 68;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 68;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[6] = level_6_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_1_OFF : class LEVEL_1_OFF
            //
            public static class LEVEL_1_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 1 level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_1_off = 34;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 34;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[1] = level_1_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_2_OFF : class LEVEL_2_OFF
            //
            public static class LEVEL_2_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 2 level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_2_off = 38;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 38;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[2] = level_2_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_3_OFF : class LEVEL_3_OFF
            //
            public static class LEVEL_3_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 3 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_3_off = 48;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 48;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[3] = level_3_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_4_OFF : class LEVEL_4_OFF
            //
            public static class LEVEL_4_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 4 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_4_off = 45;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 36;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[4] = level_4_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_5_OFF : class LEVEL_5_OFF
            //
            public static class LEVEL_5_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 5 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_5_off = 43;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 43;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[5] = level_5_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_6_OFF : class LEVEL_6_OFF
            //
            public static class LEVEL_6_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 6 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_6_off = 60;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[6] = level_6_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            public static bool check_for_higher_speed_level(int start_index)
            {
                int i = start_index;
                bool result = false;

                while (!result && i <= MAX_SPEED_NR)
                {
                    result = result || (speed[i] == actual_level);
                    i++;
                }
                return result;
            }

            public static bool init()
            {
                speed[0] = FAN_0_SPEED.fan_0_speed;
                speed[1] = FAN_1_SPEED.fan_1_speed;
                speed[2] = FAN_2_SPEED.fan_2_speed;
                speed[3] = FAN_3_SPEED.fan_3_speed;
                speed[4] = FAN_4_SPEED.fan_4_speed;
                speed[5] = FAN_5_SPEED.fan_5_speed;
                speed[6] = FAN_6_SPEED.fan_6_speed;

                on_temp[0] = 0;
                on_temp[1] = LEVEL_1_ON.level_1_on;
                on_temp[2] = LEVEL_2_ON.level_2_on;
                on_temp[3] = LEVEL_3_ON.level_3_on;
                on_temp[4] = LEVEL_4_ON.level_4_on;
                on_temp[5] = LEVEL_5_ON.level_5_on;
                on_temp[6] = LEVEL_6_ON.level_6_on;
                on_temp[7] = 200;

                off_temp[0] = 0;
                off_temp[1] = LEVEL_1_OFF.level_1_off;
                off_temp[2] = LEVEL_2_OFF.level_2_off;
                off_temp[3] = LEVEL_3_OFF.level_3_off;
                off_temp[4] = LEVEL_4_OFF.level_4_off;
                off_temp[5] = LEVEL_5_OFF.level_5_off;
                off_temp[6] = LEVEL_6_OFF.level_6_off;
                off_temp[7] = 200;

                return true;
            }

            public static bool refresh()
            {
                bool result = false;
                bool find = false;
                bool previous_level = false;
                int temp = 0;
                int i = 0;

                // read actual CPU temp
                result = ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.ECPU", ref temp);

                while (!find && (i <= MAX_SPEED_NR))
                {
                    // Check, if the previous temp was higher then the actual
                    previous_level = check_for_higher_speed_level(i + 1);

                    // Search the temp window for the actual temp
                    // If the previous temp was lower, than the upper temp boundary is the normal "temp on" value of the next window
                    // If the previous temp was higher, than the upper temp boundary is temp off value of the next window

                    if ((temp >= on_temp[i]) &&
                         (((temp < on_temp[i + 1]) && !previous_level) ||
                          ((temp <= off_temp[i + 1]) && previous_level)))
                    {
                        // If just the right fan speed? Than, no need to set another time
                        if (speed[i] != actual_level)
                        {
                            //speed 1-9 is manually set, 10 - 12 are temperature controled with different max fan speeds
                            switch (speed[i])
                            {
                                case 10:
                                    result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", (0x8F));
                                    break;

                                case 11:
                                    result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", (0x9F));
                                    break;

                                case 12:
                                    result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", (0xFF));
                                    break;

                                default:
                                    result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", ((speed[i] + 6) << 3) | 0x07);
                                    break;
                            }
                            // The | 0x07 is not really justified, but it is not that important... If you put | 0x00 instead, then the fan will really be off !
                            actual_level = speed[i];
                        }
                        // Break the search
                        find = true;
                    }
                    i++;
                }

                return result;
            }


        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Asus F3JP : class F3JP
    //
    // Fan control for Asus F3JP
    // User class by Martin N°ssing
    //
    // The Fan speed will be controlled by the _SB.PCI0.SBRG.EC0.WMFN register in the Embedded Controller.
    // WMFN is a 8 bit register. The MSB (Bit 7) control the method of fan control:
    //  manual = 0, automatic (default)= 1
    // The next 4 Bit (Bit 6 - 2) sets the fan speed (only when Bit 7 is 0):
    //  value 0x0 to 0x5: fan is off
    //  from value 0x5 to 0xF: fan speeds in ascending order
    //  The only problem is that a maximum fan speed set in WMFN(0xF) is not the realy maximum speed of the fan. In automatic mode,
    //  the fan can drive the motor more faster on higher tempertures!
    //
    // The Fan control of this class has 5 "temperatures on values" with the corresponding fan speed 0-9.
    // "FAN 0 speed" means the fan speed seated on temperatures under "FAN ON 1 LEVEL".
    // If the fan speed is set to 10, the program goes in automatic mode and allows to drive the fan very fast
    // (a little workaround for the problem mentioned above, but only for the appropriate temperature window).
    // The control class allows also to set 5 "temperatures off values" to realize a hysteresis.
    // The temperatures must are in ascendent order! The class not check this.
    // The class is not realy tested, please feel free to fix or expand the functionality
    //
    //****NOTE!!:IF YOU TURN YOUR FAN OFF MANUALLY, OVERHEATING MAY OCCUR.!!****
    //
    public static class F3JP
    {
        public const string author = "Martin N°ssing";

        #region Class for Asus F3JC LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = false;                              // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 10;                             // It must have the same name as the class (case are ignored)

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 15;                        // maximum input value
                    public const int nhc_default_value = 10;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        return ACPI.METHOD.SetValue("_SB.ATKD.SPLV", brightness_level);
                    }
                }

            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                bool result = ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
                return result;
            }

            // Function to get and refresh the brightness level (it must have the name get_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }

        }
        //
        #endregion

        #region Class for Asus F3JC FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            // Global variables for FAN control
            public static int actual_level = -1;
            public const int refresh_interval = 1;
            public const int MAX_SPEED_NR = 5;

            // Global fan control data
            public static int[] speed = new int[MAX_SPEED_NR + 1];
            public static int[] on_temp = new int[MAX_SPEED_NR + 2];
            public static int[] off_temp = new int[MAX_SPEED_NR + 2];

            #region Value class for FAN_0_SPEED : class FAN_0_SPEED
            //
            public static class FAN_0_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 0 speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_0_speed = 0;                              // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 0;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[0] = fan_0_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_1_SPEED : class FAN_1_SPEED
            //
            public static class FAN_1_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 1 speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_1_speed = 1;                              // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 1;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[1] = fan_1_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_2_SPEED : class FAN_2_SPEED
            //
            public static class FAN_2_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 2 speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_2_speed = 3;                           // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 3;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[2] = fan_2_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_3_SPEED : class FAN_3_SPEED
            //
            public static class FAN_3_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 3 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_3_speed = 6;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 6;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[3] = fan_3_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_4_SPEED : class FAN_4_SPEED
            //
            public static class FAN_4_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 4 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_4_speed = 9;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 9;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[4] = fan_4_speed;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_5_SPEED : class FAN_5_SPEED
            //
            public static class FAN_5_SPEED
            {
                // Properties of the value class
                public const string description = "FAN 5 speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_5_speed = 9;                             // It must have the same name as the class (case are ignored)
                public const string unit = "";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                       // minimum input value
                    public const int nhc_maximum_value = 10;                       // maximum input value
                    public const int nhc_default_value = 10;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        speed[5] = fan_5_speed;
                        return true;
                    }
                }
            }
            //
            #endregion



            #region  Value class for LEVEL_1_ON : class LEVEL_1_ON
            //
            public static class LEVEL_1_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 1 level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_1_on = 45;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[1] = level_1_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_2_ON : class LEVEL_2_ON
            //
            public static class LEVEL_2_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 2 level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_2_on = 50;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[2] = level_2_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_3_ON : class LEVEL_3_ON
            //
            public static class LEVEL_3_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 3 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_3_on = 55;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 55;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[3] = level_3_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_4_ON : class LEVEL_4_ON
            //
            public static class LEVEL_4_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 4 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_4_on = 60;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 36;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[4] = level_4_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_5_ON : class LEVEL_5_ON
            //
            public static class LEVEL_5_ON
            {
                // Properties of the value class
                public const string description = "FAN ON 5 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_5_on = 65;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        on_temp[5] = level_5_on;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_1_OFF : class LEVEL_1_OFF
            //
            public static class LEVEL_1_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 1 level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_1_off = 43;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 43;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[1] = level_1_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_2_OFF : class LEVEL_2_OFF
            //
            public static class LEVEL_2_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 2 level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_2_off = 48;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 48;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[2] = level_2_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_3_OFF : class LEVEL_3_OFF
            //
            public static class LEVEL_3_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 3 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_3_off = 53;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 35;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 53;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[3] = level_3_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_4_OFF : class LEVEL_4_OFF
            //
            public static class LEVEL_4_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 4 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_4_off = 58;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 36;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 58;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[4] = level_4_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for LEVEL_5_OFF : class LEVEL_5_OFF
            //
            public static class LEVEL_5_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF 5 level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int level_5_off = 63;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 38;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 63;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        // reset actual level
                        actual_level = -1;
                        off_temp[5] = level_5_off;
                        return true;
                    }
                }
            }
            //
            #endregion

            public static bool check_for_higher_speed_level(int start_index)
            {
                int i = start_index;
                bool result = false;

                while (!result && i <= MAX_SPEED_NR)
                {
                    result = result || (speed[i] == actual_level);
                    i++;
                }
                return result;
            }

            public static bool init()
            {
                speed[0] = FAN_0_SPEED.fan_0_speed;
                speed[1] = FAN_1_SPEED.fan_1_speed;
                speed[2] = FAN_2_SPEED.fan_2_speed;
                speed[3] = FAN_3_SPEED.fan_3_speed;
                speed[4] = FAN_4_SPEED.fan_4_speed;
                speed[5] = FAN_5_SPEED.fan_5_speed;

                on_temp[0] = 0;
                on_temp[1] = LEVEL_1_ON.level_1_on;
                on_temp[2] = LEVEL_2_ON.level_2_on;
                on_temp[3] = LEVEL_3_ON.level_3_on;
                on_temp[4] = LEVEL_4_ON.level_4_on;
                on_temp[5] = LEVEL_5_ON.level_5_on;
                off_temp[6] = 200;

                off_temp[0] = 0;
                off_temp[1] = LEVEL_1_OFF.level_1_off;
                off_temp[2] = LEVEL_2_OFF.level_2_off;
                off_temp[3] = LEVEL_3_OFF.level_3_off;
                off_temp[4] = LEVEL_4_OFF.level_4_off;
                off_temp[5] = LEVEL_5_OFF.level_5_off;
                off_temp[6] = 200;

                return true;
            }

            public static bool refresh()
            {
                bool result = false;
                bool find = false;
                bool previous_level = false;
                int temp = 0;
                int i = 0;

                // read actual CPU temp
                result = ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.ECPU", ref temp);

                while (!find && (i <= MAX_SPEED_NR))
                {
                    // Check, if the previous temp was higher then the actual
                    previous_level = check_for_higher_speed_level(i + 1);

                    // Search the temp window for the actual temp
                    // If the previous temp was lower, than the upper temp boundary is the normal "temp on" value of the next window
                    // If the previous temp was higher, than the upper temp boundary is temp off value of the next window

                    if ((temp >= on_temp[i]) &&
                         (((temp < on_temp[i + 1]) && !previous_level) ||
                          ((temp <= off_temp[i + 1]) && previous_level)))
                    {
                        // If just the right fan speed? Than, no need to set another time
                        if (speed[i] != actual_level)
                        {
                            result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", ((speed[i] + 6) << 3) | 0x07);
                            actual_level = speed[i];
                        }
                        // Break the search
                        find = true;
                    }
                    i++;
                }

                return result;
            }


        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Asus F3JV : class F3JV
    //
    // class author: cloud
    // Tested with Asus F3JV Bios Version 205, ATK0100 060906, NHC 2.0 Pre-04
    //
    public static class F3JV
    {
        public const string author = "cloud";

        #region class for Asus F3JV LCD Brightness control : class BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";              // Description of current class
            public const bool default_enabled = false;                               // true = By default the current class is enabled in NHC
            public const int icon = 1;                                               // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level (0-15)";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 15;                             // It must have the same name as the class (case are ignored)

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 15;                        // maximum input value
                    public const int nhc_default_value = 15;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        return ACPI.METHOD.SetValue("_SB.ATKD.SPLV", brightness_level);
                    }
                }

            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                bool result = ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
                return result;
            }

            // Function to get and refresh the brightness level (it must have the name get_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }





        }
        //
        #endregion


        //deactivated since ACPI method seems to affect only the WLAN LED
        /*

        #region class for WLAN control : class WLAN_CONTROL
        //
        public static class WLAN_CONTROL
        {
            // Default constants for the hardware class
            public const string description = "WLAN Control";                     // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region  Value class for the example_value : class SET_WLAN
            //
            public static class SET_WLAN
            {
                // Properties of the value class
                public const string description = "WLAN enabled";                          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int set_wlan = 0;                                     // It must have the same name as the class (case are ignored)
                //public const string unit = "OFF|ON";                                // unit of the example_value class.
                                                                                    // If the class NHC_WRITE is available, nhc_minimum_value = 0 and nhc_maximum_value = 1 then
                                                                                    // the unit value "OFF|ON" is interpreted as "OFF" for the value 0 and "ON" for the value 1

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 1;                         // the maximum value of example_value
                    public const int nhc_default_value = 1;                         // the default value of example_value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {

                      if (set_wlan == 0)
                      {
                          //return ACPI.METHOD.SetValue("_SB.ATKD.WLED", (0x00));
                        bool result = ACPI.METHOD.SetValue("OWLD", 0);
                        //int i = (0x1B << 8 |  0x01 << 4  |  0x00);
                        //bool result = ACPI.METHOD.SetValue("SGPL", i);
                        return result; //ACPI.FIELD.Write("WLDP", 0);


                      }
                      else
                      {
                        bool result = ACPI.METHOD.SetValue("OWLD", 1);
                        //return ACPI.METHOD.SetValue("OWLD", (0x01));
                        //int i = (0x1B << 8 |  0x01 << 4  |  0x01);
                        //bool result = ACPI.METHOD.SetValue("SGPL", i);
                        return result;
                      }

                    }
                }
            }
            //
            #endregion
      }
        #endregion

        //*/


        #region class for Bluetooth control : class BT_CONTROL
        //
        public static class BT_CONTROL
        {
            // Default constants for the hardware class
            public const string description = "Bluetooth Control";                  // Description of current class
            public const bool default_enabled = false;                              // true = By default the current class is enabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            #region  Value class for SET_BT : class SET_BT

            public static class SET_BT
            {
                // Properties of the value class
                public const string description = "Bluetooth enabled";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int set_bt = 0;                                       // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of the example_value class.
                // If the class NHC_WRITE is available, nhc_minimum_value = 0 and nhc_maximum_value = 1 then
                // the unit value "OFF|ON" is interpreted as "OFF" for the value 0 and "ON" for the value 1

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 1;                         // the maximum value of example_value
                    public const int nhc_default_value = 0;                         // the default value of example_value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (set_bt == 0)
                        {

                            return ACPI.METHOD.SetValue("OBTD", (0x00));

                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("OBTD", (0x01));
                        }
                    }
                }
            }

            #endregion

            #region  Value class for CUR_CAPACITY : class CUR_CAPACITY
            //
            public static class CUR_CAPACITY
            {
                // Properties of the value class
                public const string description = "Current Battery Capacity (%)";                          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int cur_capacity = 0;                                     // It must have the same name as the class (case are ignored)


            }
            //
            #endregion

            #region  Value class for BAT_CHK : class BAT_CHK
            //
            public static class BAT_CHK
            {
                // Properties of the value class
                public const string description = "Battery monitoring";                          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bat_chk = 1;                                     // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 1;                         // the maximum value of example_value
                    public const int nhc_default_value = 1;                         // the default value of example_value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        return true;
                    }
                }
            }
            //
            #endregion

            #region  Value class for THRESHOLD_CAP : class THRESHOLD_CAP
            //
            public static class THRESHOLD_CAP
            {
                // Properties of the value class
                public const string description = "Turn off Bluetooth if battery capacity drops under (%)";                          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int threshold_cap = 0;                                     // It must have the same name as the class (case are ignored)

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                               // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                           // the minimum value of example_value
                    public const int nhc_maximum_value = 100;                         // the maximum value of example_value
                    public const int nhc_default_value = 10;                          // the default value of example_value
                    public static bool nhc_on_write()                                 // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        return true;
                    }
                }
            }
            //
            #endregion

            public static bool refresh()
            {
                bool result = true;

                if (BAT_CHK.bat_chk == 1)
                {
                    int capacity = 0;
                    result = ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.B0PN", ref capacity);
                    CUR_CAPACITY.cur_capacity = capacity;
                    if (CUR_CAPACITY.cur_capacity <= THRESHOLD_CAP.threshold_cap && CUR_CAPACITY.cur_capacity > 0)
                    {
                        result = ACPI.METHOD.SetValue("OBTD", (0x00));
                        SET_BT.set_bt = 0;
                    }
                }
                return result;
            }

        }
        #endregion   //BT_CONTROL

        #region class for Asus F3JV FAN control : class FAN
        //
        public static class FAN
        {
            // Default constants for the hardware class
            public const string description = "Fan Control";                     // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            public static int last_cpu_temp = 40;
            public static int last_speed_setting = 100;
            public static bool cooldown = false;
            public static int cooldowntimer = 0;
            public static int maxspeed = 255;

            #region  Value class for ENABLED : class ENABLED
            //
            public static class ENABLED
            {
                // Properties of the value class
                public const string description = "Manual fan control";          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int enabled = 0;
                public const string unit = "OFF|ON";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 1;                         // the maximum value of example_value
                    public const int nhc_default_value = 1;                         // the default value of example_value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (enabled == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", maxspeed);
                        }
                        else
                        {
                            cooldowntimer = 0;
                            cooldown = false;
                            last_speed_setting = maxspeed;
                            return true;
                        }

                    }
                }
            }
            //
            #endregion

            #region  Value class for ACT_SPEED : class ACT_SPEED
            //
            public static class ACT_SPEED
            {
                // Properties of the value class
                public const string description = "Current fanspeed (rpm)";          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int act_speed = 0;                                     // It must have the same name as the class (case are ignored)

            }
            //
            #endregion

            #region  Value class for ACT_CPU : class ACT_CPU
            //
            public static class ACT_CPU
            {
                // Properties of the value class
                public const string description = "Current temperature of CPU (°C)";          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int act_cpu = 0;                                     // It must have the same name as the class (case are ignored)

            }
            //
            #endregion

            #region  Value class for LOWER_TEMP : class LOWER_TEMP
            //
            public static class LOWER_TEMP
            {
                // Properties of the value class
                public const string description = "Temperature for low fan speed (30 - 49°C)";                          // Description of current value
                public static bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int lower_temp = 30;                                     // It must have the same name as the class (case are ignored)

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public static bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 49;                         // the maximum value of example_value
                    public const int nhc_default_value = 30;                         // the default value of example_value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        return true;
                    }
                }
            }
            #endregion

            #region  Value class for UPPER_TEMP : class UPPER_TEMP
            //
            public static class UPPER_TEMP
            {
                // Properties of the value class
                public const string description = "Temperature for high fan speed (50 - 80°C)";                          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int upper_temp = 55;                                     // It must have the same name as the class (case are ignored)

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 50;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 80;                         // the maximum value of example_value
                    public const int nhc_default_value = 55;                         // the default value of example_value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        return true;
                    }
                }
            }
            #endregion

            #region  Value class for COOLDOWN_PERIOD : class COOLDOWN_PERIOD
            //
            public static class COOLDOWN_PERIOD
            {
                // Properties of the value class
                public const string description = "Cool down after (0(never) - 3600 sec)";                          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int cooldown_period = 0;                                     // It must have the same name as the class (case are ignored)

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 3600;                         // the maximum value of example_value
                    public const int nhc_default_value = 900;                         // the default value of example_value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        cooldowntimer = 0;
                        return true;
                    }
                }
            }
            #endregion

            #region  Value class for TARGET_TEMP : class TARGET_TEMP

            public static class TARGET_TEMP
            {
                // Properties of the value class
                public const string description = "Cool down to (30 - 50°C)";                   // Description of current value
                public const bool nhc_visible = true;                                    // true -> value is visible in NHC

                // Value
                public static int target_temp = 55;                                      // It must have the same name as the class (case are ignored)

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                              // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 50;                         // the maximum value of example_value
                    public const int nhc_default_value = 45;                         // the default value of example_value
                    public static bool nhc_on_write()                                // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        return true;
                    }
                }
            }
            #endregion

            #region  Value class for COOLDOWN_TIME : class COOLDOWN_TIME

            public static class COOLDOWN_TIME
            {
                // Properties of the value class
                public const string description = "Cool down for (5 - 120sec)";                   // Description of current value
                public const bool nhc_visible = true;                                    // true -> value is visible in NHC

                // Value
                public static int cooldown_time = 20;                                      // It must have the same name as the class (case are ignored)

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                              // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 120;                         // the maximum value of example_value
                    public const int nhc_default_value = 20;                         // the default value of example_value
                    public static bool nhc_on_write()                                // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        return true;
                    }
                }
            }
            #endregion

            #region  Value class for MAX_SPEED : class MAX_SPEED
            //
            public static class MAX_SPEED
            {
                // Properties of the value class
                public const string description = "Level of max. fan speed (1-5)";                          // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int max_speed = 5;                                     // It must have the same name as the class (case are ignored)

                // With this optional class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 1;                         // the minimum value of example_value
                    public const int nhc_maximum_value = 5;                         // the maximum value of example_value
                    public const int nhc_default_value = 5;                         // the default value of example_value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        switch (max_speed)
                        {
                            case 1:
                                maxspeed = 128;
                                break;
                            case 2:
                                maxspeed = 134;
                                break;
                            case 3:
                                maxspeed = 140;
                                break;
                            case 4:
                                maxspeed = 146;
                                break;
                            case 5:
                                maxspeed = 255;
                                break;
                            default:
                                break;
                        }

                        return true;
                    }
                }
            }
            #endregion

            public static bool refresh()
            {
                bool result = false;
                int act_speed = 0;

                //read current cpu temperature
                result = ACPI.FIELD.Read("_TZ.LTMP", ref ACT_CPU.act_cpu);

                //read current fan speed
                try
                {
                    result = ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.TAH0", ref act_speed);

                    if (act_speed != 0)
                    {
                        ACT_SPEED.act_speed = 2387166 / act_speed;                 //value from comparison of TAH0 and RPM of Asus NBProbe
                    }

                }
                catch
                {
                    ACT_SPEED.act_speed = 0;
                }

                if (ENABLED.enabled == 1)                     //check if fan control is enabled
                {

                    if (!cooldown)
                    {
                        //Check if Cooldown is necessary
                        if (COOLDOWN_PERIOD.cooldown_period != 0)
                        {
                            cooldowntimer++;
                            if (cooldowntimer > COOLDOWN_PERIOD.cooldown_period)
                            {
                                cooldown = true;
                                cooldowntimer = 0;
                            }
                        }


                        if (ACT_CPU.act_cpu <= LOWER_TEMP.lower_temp)
                        {
                            //only change value if significant change
                            if ((last_speed_setting - 50) >= 2)
                            {
                                result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", 0);
                                last_speed_setting = 50;
                            }
                        }
                        else if (ACT_CPU.act_cpu >= UPPER_TEMP.upper_temp)
                        {
                            //only change value if significant change
                            if ((maxspeed - last_speed_setting) >= 2 || (last_speed_setting - maxspeed) >= 2)                     //only change value if significant change
                            {
                                result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", maxspeed);
                                last_speed_setting = maxspeed;
                                cooldown = true;
                            }
                        }
                        else
                        {
                            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                            //                                                   WMFN bit 76543210
                            //the main fanspeed setting: bit 7 of WMFN register gives fan control to embedded controller if 1       1XXXXXXX    int value >= 128
                            //max rpm is determined by bit 6, 5, 4                                    101XXXXX    255 > int value >= 128
                            //if bit 7 is zero, bit 6-0 determine fan speed, relevant speeds from 85 to 127               0XXXXXXX    127 >= int value >= 85
                            //
                            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                            /**
                            int multiplier = (int) (77 * (
                             (-((((ACT_CPU.act_cpu - LOWER_TEMP.lower_temp) / (UPPER_TEMP.upper_temp - LOWER_TEMP.lower_temp))-1))) + 1
                             ));

                            double multiplier = (((double)ACT_CPU.act_cpu - (double)LOWER_TEMP.lower_temp) / ((double)UPPER_TEMP.upper_temp - (double)LOWER_TEMP.lower_temp));
                            multiplier -= 1.0;

                            int speed = 30 + (int) (97.0 *(-((multiplier)*(multiplier)) + 1.0));
                            //**/
                            int multiplier = (int)(77 * (ACT_CPU.act_cpu - LOWER_TEMP.lower_temp) / (UPPER_TEMP.upper_temp - 4 - LOWER_TEMP.lower_temp));

                            int speed = 50 + multiplier;
                            if (speed > 127)
                            {
                                speed = 127;
                            }

                            if ((last_speed_setting - speed) >= 6) //only spin down if significant change
                            {
                                if (last_speed_setting > 127)      //if last speed was maxspeed, spin down beginning at 127
                                {
                                    last_speed_setting = 127;
                                }
                                else
                                {
                                    last_speed_setting -= 3;      //spin down in small steps
                                }
                                result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", (last_speed_setting));

                            }
                            if ((speed - last_speed_setting) >= 2)
                            {
                                result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", speed);
                                last_speed_setting = speed;
                            }

                        }


                    }

                    else
                    {
                        //look for changed MAX_SPEED.max_speed
                        if ((maxspeed - last_speed_setting) >= 2 || (last_speed_setting - maxspeed) >= 2)                     //only change value if significant change
                        {
                            result = ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", maxspeed);
                            last_speed_setting = maxspeed;
                        }

                        cooldowntimer++;

                        //keep MAX_SPEED.max_speed until target_temp is reached
                        if (ACT_CPU.act_cpu < TARGET_TEMP.target_temp && cooldowntimer > COOLDOWN_TIME.cooldown_time)
                        {
                            cooldown = false;
                            cooldowntimer = 0;
                            last_cpu_temp = 0;
                            last_speed_setting = maxspeed;
                        }
                    }

                }
                last_cpu_temp = ACT_CPU.act_cpu;
                return result;

            }

            public static bool finish()
            {
                return ACPI.METHOD.SetValue("_SB.PCI0.SBRG.EC0.WMFN", maxspeed);
            }

        }
        #endregion  //class FAN

    }
    #endregion

    #region Notebook Asus M3N : class M3N
    //
    // class author: OndraS
    //
    public static class M3N
    {
        public const string author = "OndraS";

        #region Class for Asus M3N LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 8;                             // It must have the same name as the class (case are ignored)

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = minimum_brightness_level;                         // the minimum input value
                    public const int nhc_maximum_value = maximum_brightness_level;                         // the maximum input value
                    public const int nhc_default_value = 8;                         // the default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        return set_brightness(brightness_level);
                    }
                }
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                if (initialisation) return true;
                return ACPI.METHOD.SetValue("_SB.ATKD.SPLV", new_level);
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                bool result = ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);     // get the brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        //
        #endregion

        #region Class for Asus M3N Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region class for OVERCLOCK : class OVERCLOCK
            //
            public static class OVERCLOCK
            {
                // Properties of the value class
                public const string description = "CPU Overlock";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int overclock = 0;                                    // It must have the same name as the class (case are ignored)
                public const string unit = "   (0 = clock down; 1 = default clock; 2,3,4 = over clock)";    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum input value
                    public const int nhc_maximum_value = 4;                         // the maximum input value
                    public const int nhc_default_value = 1;                         // the default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        int returnValue = 0;
                        return ACPI.METHOD.SetValueWithReturn("_SB.ATKD.SFRQ", overclock, ref returnValue);
                    }
                }
            }
            //
            #endregion

            #region class for M3N Mailbox LED: class MAILBOX_LED
            //
            public static class MAILBOX_LED
            {
                // Properties of the value class
                public const string description = "Mailbox LED";      // Description of current value
                public const bool nhc_visible = true;         // true -> value is visible in NHC

                // Value
                public static int mailbox_led = 0;          // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";          // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;       // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;       // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;       // the maximum value of wlan_status
                    public const int nhc_default_value = 0;       // the default value of wlan_status
                    public static bool nhc_on_write()
                    {
                        if (mailbox_led == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.MLED", 1);     // SET MAILBOX LED
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.MLED", 0);
                        }
                    }
                }
            }
            //
            #endregion

        }
        //
        #endregion

        #region Class for Asus M3N FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // OperationRegion (\RAMW, SystemMemory, RAMB, 0xFF)
            // Field (\RAMW, ByteAcc, NoLock, Preserve)
            // {
            //     . . .
            //     . . .
            //     Offset (0xBE),
            //     PADL,   16,
            //     CADL,   16,
            //     CSTE,   16,
            //     NSTE,   16,
            //     SSTE,   16,
            //     SFUN,   8,
            //     TSAD,   8,
            //     TAC3,   8,        // 48°C         <- FAN ON low level
            //     TAC2,   8,        // 68°C         <- FAN ON middle level
            //     TAC1,   8,        // 78°C         <- FAN ON high level
            //     TAC0,   8,        // 86°C         <- FAN ON maximum level
            //     TPSV,   8,        // 105°C        <- clock down
            //     TCRT,   8,        // 110°C        <- turn off computer
            //     F1L0,   8,        // 254 -rmp     <- FAN OFF
            //     F2L0,   8,        // 0
            //     F1L1,   8,        // 181 -rmp     <- FAN low speed
            //     F2L1,   8,        // 0
            //     F1L2,   8,        // 149 -rmp     <- FAN middle speed
            //     F2L2,   8,        // 0
            //     F1L3,   8,        // 139 -rmp     <- FAN high speed
            //     F2L3,   8,        // 0
            //     F1L4,   8,        // 112 -rmp     <- FAN maximum speed
            //     F2L4,   8,        // 0
            //     SLPT,   8,
            //     DBRD,   32,
            //     SIDS,   8,
            //     Offset (0xE3),
            //     CPUS,   8
            // }
            //
            //  Info:   To get the above values you can use the ACPI.FIELD.Read("name", ref value) function
            //          Example: int value = 0; ACPI.FIELD.Read("TAC3", ref value);

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 130;                              // It must have the same name as the class (case are ignored)
                public const string unit = "*10 rpm";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 120;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 130;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("F1L1", fan_low_speed) == true)        // set the fan_low_speed value in the buffer
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }

                /*                public static bool get_fan_low_speed(ref int level)
                                {
                                    bool result = ACPI.FIELD.Read("F1L1", ref level);     // get the brightness level
                                    FAN_LOW_SPEED.fan_low_speed= level;
                                    return result;
                                }
                 */
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed = 170;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*10 rpm";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 112;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 170;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("F1L2", fan_middle_speed) == true)     // set the fan_low_speed value in the buffer
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 255;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*10 rpm";                                 // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 112;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 255;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("F1L2", fan_high_speed) == true)       // set the fan_low_speed value in the buffer
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 48;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 68;                        // maximum input value
                    public const int nhc_default_value = 58;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("TAC3", low_level_on) == true)         // set the low_level value in the field
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_on = 68;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 48;                        // minimum input value
                    public const int nhc_maximum_value = 78;                        // maximum input value
                    public const int nhc_default_value = 68;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("TAC2", middle_level_on) == true)      // set the low_level value in the field
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region  Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 78;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 68;                        // minimum input value
                    public const int nhc_maximum_value = 86;                        // maximum input value
                    public const int nhc_default_value = 78;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.FIELD.Write("TAC1", high_level_on) == true)        // set the low_level value in the field
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_TZ.TCHG");                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_TZ.TCHG");                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }

        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook ASUS V6V : class V6V
    //
    // class author: Manfred Jaider
    //
    public static class V6V
    {
        public const string author = "Manfred Jaider";

        #region Class for ASUS V6V LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return A7D.BRIGHTNESS.set_brightness(new_level);                    // we can use the ASUS A7D set_brightness function (brightness control works in the same way)
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                return A7D.BRIGHTNESS.get_brightness(ref level);                    // we can use the ASUS A7D get_brightness function (brightness control works in the same way)
            }
        }
        //
        #endregion

        #region Class for ASUS V6V Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_CONTROL : class WLAN_CONTROL
            //
            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for BLUETOOTH_CONTROL : class BLUETOOTH_CONTROL
            //
            public static class BLUETOOTH_CONTROL
            {
                // Properties of the value class
                public const string description = "Bluetooth";                      // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bluetooth_control = 1;                            // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (bluetooth_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 0);        // turn off the bluetooth
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 1);        // turn on the bluetooth
                        }
                    }
                }
            }
            //
            #endregion

        }
        //
        #endregion

        #region Class for Asus V6V FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Name (FSTL, Package (0x06)
            // {
            //    0x00,         // 0*rmp        // FAN OFF
            //    0x8E,         // 142*rpm      // FAN low speed
            //    0xB2,         // 178*rpm      // FAN middle speed
            //    0xE5,         // 229*rpm      // FAN high speed
            //    0xFF,         // 255*rpm      // FAN maximum speed
            //    0xFF          // 255*rpm
            // })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 142;                              // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 50;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 142;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[1]", fan_low_speed) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed = 178;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 100;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 178;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[2]", fan_middle_speed) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 229;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 150;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 229;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[3]", fan_high_speed) == true)     // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            // Name (HTTL, Package (0x06)
            // {
            //    0x2D,         // 45°C     <- FAN ON low level
            //    0x37,         // 55°C     <- FAN ON middle level
            //    0x46,         // 70°C     <- FAN ON high level
            //    0x50,         // 80°C     <- FAN ON maximum level
            //    0x7F,         // 127°C
            //    0x7F          // 127°C
            // })
            // Name (LTTL, Package (0x06)
            // {
            //    0x00,
            //    0x19,         // 25°C     <- FAN OFF low level
            //    0x32,         // 50°C     <- FAN OFF middle level
            //    0x41,         // 65°C     <- FAN OFF high level
            //    0x4B,         // 75°C     <- FAN OFF maximum level
            //    0x7F          // 127°C
            // })

            #region Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 25;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 50;                        // maximum input value
                    public const int nhc_default_value = 25;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[1]", low_level_off) == true)    // set the low_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 45;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // minimum input value
                    public const int nhc_maximum_value = 65;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[0]", low_level_on) == true)     // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_OFF : class MIDDLE_LEVEL_OFF
            //
            public static class MIDDLE_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_off = 50;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[2]", middle_level_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_on = 55;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 55;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[1]", middle_level_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 65;                              // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[4]", high_level_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 70;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 70;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[2]", high_level_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_TZ.STRP");                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook ASUS V6VA : class V6VA
    //
    // class author: Manfred Jaider
    //
    public static class V6VA
    {
        public const string author = "Manfred Jaider";

        #region Class for ASUS V6VA LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return A7D.BRIGHTNESS.set_brightness(new_level);                    // we can use the ASUS A7D set_brightness function (brightness control works in the same way)
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                return A7D.BRIGHTNESS.get_brightness(ref level);                    // we can use the ASUS A7D get_brightness function (brightness control works in the same way)
            }
        }
        //
        #endregion

        #region Class for ASUS V6VA Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_CONTROL : class WLAN_CONTROL
            //
            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for BLUETOOTH_CONTROL : class BLUETOOTH_CONTROL
            //
            public static class BLUETOOTH_CONTROL
            {
                // Properties of the value class
                public const string description = "Bluetooth";                      // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bluetooth_control = 1;                            // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (bluetooth_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 0);        // turn off the bluetooth
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 1);        // turn on the bluetooth
                        }
                    }
                }
            }
            //
            #endregion

        }
        //
        #endregion

        #region Class for Asus V6VA FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Name (FSTL, Package (0x06)
            // {
            //    0x00,         // 0*rmp        // FAN OFF
            //    0x7B,         // 123*rpm      // FAN low speed
            //    0xA8,         // 168*rpm      // FAN middle speed
            //    0xD9,         // 217*rpm      // FAN high speed
            //    0xFF,         // 255*rpm      // FAN maximum speed
            //    0xFF          // 255*rpm
            // })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 123;                              // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 50;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 123;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[1]", fan_low_speed) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed = 168;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 100;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 168;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[2]", fan_middle_speed) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 217;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 150;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 217;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[3]", fan_high_speed) == true)     // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            // Name (HTTL, Package (0x06)
            // {
            //    0x3A,         // 58°C     <- FAN ON low level
            //    0x46,         // 70°C     <- FAN ON middle level
            //    0x50,         // 80°C     <- FAN ON high level
            //    0x58,         // 88°C     <- FAN ON maximum level
            //    0x7F,         // 127°C
            //    0x7F          // 127°C
            // })
            // Name (LTTL, Package (0x06)
            // {
            //    0x00,
            //    0x32,         // 50°C     <- FAN OFF low level
            //    0x41,         // 65°C     <- FAN OFF middle level
            //    0x49,         // 73°C     <- FAN OFF high level
            //    0x52,         // 82°C     <- FAN OFF maximum level
            //    0x7F          // 127°C
            // })

            #region Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 50;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 65;                        // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[1]", low_level_off) == true)    // set the low_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 58;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 58;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[0]", low_level_on) == true)     // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_OFF : class MIDDLE_LEVEL_OFF
            //
            public static class MIDDLE_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_off = 65;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[2]", middle_level_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_on = 70;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 70;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[1]", middle_level_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 73;                              // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 73;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[4]", high_level_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 80;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 88;                        // maximum input value
                    public const int nhc_default_value = 80;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[2]", high_level_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_TZ.STRP");                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Asus W1G : class W1G
    //
    // Class author: nullpointer@mail.ru
    // last updated: 23:33 17.03.2007
    // Bios Version: 0200
    //
    public static class W1G
    {
        public const string author = "nullpointer@mail.ru";

        #region Class for Asus W1G FAN control : class FAN_W1G
        public static class FAN_W1G
        {
            public const string description = "ACPI fan manual software control";
            public const bool default_enabled = false;
            public const int icon = 2;

            #region Value class for FAN_CPU_TEMPERATURE : class FAN_CPU_TEMPERATURE
            public static class FAN_CPU_TEMPERATURE
            {
                public const string description = "Current system temperature";
                public const bool nhc_visible = true;
                public static int fan_cpu_temperature = 0;
                public const string unit = " °C";
            }
            #endregion

            #region Value class for FAN_RPM : class FAN_RPM
            public static class FAN_RPM
            {
                public const string description = "Current fan speed";
                public const bool nhc_visible = true;
                public static int fan_rpm = 0;
                public const string unit = " rpm";
            }
            #endregion

            #region Value class for FAN_SPEED_BIOS : class FAN_SPEED_BIOS
            public static class FAN_SPEED_BIOS
            {
                public const string description = "Default BIOS fan speeds";
                public const bool nhc_visible = true;
                public static int fan_speed_bios = 0;
                public const string unit = ", 127, 153, 230, 255";
            }
            #endregion

            #region Value class for FAN_SPEED : class FAN_SPEED
            public static class FAN_SPEED
            {
                public const string description = "Set manual fan speed (0 to 255)";
                public const bool nhc_visible = true;
                public static int fan_speed = 0;
                public const string unit = "";

                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 153;

                    public static bool nhc_on_write()
                    {
                        if (initialisation) return true;
                        SetFanSpeed(FAN_WARNING.fan_warning, FAN_SPEED.fan_speed);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for FAN_WARNING : class FAN_WARNING
            public static class FAN_WARNING
            {
                public const string description = "Hardware fan control enabled if CPU temperature is over";
                public const bool nhc_visible = true;
                public static int fan_warning = 0;
                public const string unit = "°C";

                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 65;

                    public static bool nhc_on_write()
                    {
                        if (initialisation) return true;
                        SetFanSpeed(FAN_WARNING.fan_warning, FAN_SPEED.fan_speed);
                        return true;
                    }
                }
            }
            #endregion

            private static bool SetFanSpeed(int _HLMT, int _FANV)
            {
                int value_TSAD = 0;
                int[] inArg_WBYT = { 0, 0, 0 };
                int[] inArg_RBYT = { 0, 0 };
                int[] outArg = { 0 };

                // Get value of TSAD member of RAMW fieled
                ACPI.FIELD.Read("TSAD", ref value_TSAD);

                // WBYT (TSAD, 0x4F, HLMT)
                inArg_WBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_WBYT[1] = 0x4F;       // Unknown constant; refer to W1J's DSDT disassembly
                inArg_WBYT[2] = _HLMT;      // Higher temperature trigger limit; BIOS will activate hardware fan control if temperature would above this limit
                ACPI.METHOD.Call("WBYT", inArg_WBYT, 3, ref outArg, 1);

                // WBYT (TSAD, 0x4E, LLMT)
                inArg_WBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_WBYT[1] = 0x4E;       // Unknown constant; refer to W1J's DSDT disassembly
                inArg_WBYT[2] = 0;          // Lower temperature trigger limit; set to zero to prevent hardware fan control activation
                ACPI.METHOD.Call("WBYT", inArg_WBYT, 3, ref outArg, 1);

                // WBYT (TSAD, 0x30, FANV)
                inArg_WBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_WBYT[1] = 0x30;       // Unknown constant; refer to W1J's DSDT disassembly
                inArg_WBYT[2] = _FANV;      // ACPI fan speed; BIOS uses values: 0, 127, 153, 230, 255
                ACPI.METHOD.Call("WBYT", inArg_WBYT, 3, ref outArg, 1);

                // RBYT (TSAD, 0x41)
                inArg_RBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_RBYT[1] = 0x41;       // Unknown constant; refer to W1J's DSDT disassembly
                ACPI.METHOD.Call("RBYT", inArg_RBYT, 2, ref outArg, 1);

                // RBYT (TSAD, 0x42)
                inArg_RBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_RBYT[1] = 0x41;       // Unknown constant; refer to W1J's DSDT disassembly
                ACPI.METHOD.Call("RBYT", inArg_RBYT, 2, ref outArg, 1);

                return true;
            }

            public const int refresh_interval = 2;
            public static bool refresh()
            {
                int tmpvalue = 0;

                // Get fan spped in RPMs
                ACPI.METHOD.GetValue("_TZ.RFAN", ref tmpvalue);
                FAN_RPM.fan_rpm = tmpvalue * 100;

                // Get system temperature
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref tmpvalue);
                tmpvalue = (tmpvalue - 2732) / 10;
                FAN_CPU_TEMPERATURE.fan_cpu_temperature = tmpvalue;

                return true;
            }
        }
        #endregion

        #region Class for Asus W1G SFAN control : class SFAN_W1G
        public static class SFAN_W1G
        {
            public const string description = "ACPI fan automatic software control";
            public const bool default_enabled = false;
            public const int icon = 2;

            #region Value class for SFAN_CPUTemperature : class SFAN_CPUTemperature
            public static class SFAN_CPUTemperature
            {
                public const string description = "Current system temperature";
                public const bool nhc_visible = true;
                public static int sfan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for SFAN_FanSpeed : class SFAN_FanSpeed
            public static class SFAN_FanSpeed
            {
                public const string description = "Current fan speed";
                public const bool nhc_visible = true;
                public static int sfan_fanspeed = 0;
                public const string unit = " rpm";
            }
            #endregion

            #region Value class for SFAN_Profile : class SFAN_Profile
            public static class SFAN_Profile
            {
                public const string description = "Current profile";
                public const bool nhc_visible = true;
                public static int sfan_profile = 0;
                public const string unit = "";

                public static bool init_done = false;

                public static int[] t_ = { 0, 0, 0, 0, 0, 0 };
                public static int[] s_ = { 0, 0, 0, 0, 0, 0 };
                public static int[] d_ = { 0, 0, 0, 0, 0, 0 };
                public static int[] i_ = { 1, 2, 3, 4, 5, 6 };

                public static int sfan_profile_i = -1;
            }
            #endregion

            #region Value class for SFAN_WARNING : class SFAN_WARNING
            public static class SFAN_WARNING
            {
                public const string description = "Hardware fan control enabled if CPU temperature is over";
                public const bool nhc_visible = true;
                public static int sfan_warning = 0;
                public const string unit = "°C";

                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 20;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 65;

                    public static bool nhc_on_write()
                    {
                        if (initialisation) return true;
                        SFAN_OnRefresh(true);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_UpdateSpeed : class SFAN_UpdateSpeed
            public static class SFAN_UpdateSpeed
            {
                public const string description = "Update once in";
                public const bool nhc_visible = true;
                public static int sfan_updatespeed = 0;
                public const string unit = " second(s)";

                public static int sfan_refreshdivider = 0;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 1;
                    public const int nhc_maximum_value = 20;
                    public const int nhc_default_value = 5;

                    public static bool nhc_on_write()
                    {
                        // nothing to do; value used only by timer
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV1 : class SFAN_DIV1
            public static class SFAN_DIV1
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div1 = 1;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile1_S : class SFAN_SpeedProfile1_S
            public static class SFAN_SpeedProfile1_S
            {
                public const string description = "Profile 1, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile1_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 0;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(1, SFAN_SpeedProfile1.sfan_speedprofile1, SFAN_SpeedProfile1_S.sfan_speedprofile1_s, SFAN_SpeedProfile1_D.sfan_speedprofile1_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile1 : class SFAN_SpeedProfile1
            public static class SFAN_SpeedProfile1
            {
                public const string description = "Profile 1, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile1 = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 50;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(1, SFAN_SpeedProfile1.sfan_speedprofile1, SFAN_SpeedProfile1_S.sfan_speedprofile1_s, SFAN_SpeedProfile1_D.sfan_speedprofile1_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile1_D : class SFAN_SpeedProfile1_D
            public static class SFAN_SpeedProfile1_D
            {
                public const string description = "Profile 1, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile1_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 0;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(1, SFAN_SpeedProfile1.sfan_speedprofile1, SFAN_SpeedProfile1_S.sfan_speedprofile1_s, SFAN_SpeedProfile1_D.sfan_speedprofile1_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV2 : class SFAN_DIV2
            public static class SFAN_DIV2
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div2 = 2;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile2_S : class SFAN_SpeedProfile2_S
            public static class SFAN_SpeedProfile2_S
            {
                public const string description = "Profile 2, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile2_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 144;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(2, SFAN_SpeedProfile2.sfan_speedprofile2, SFAN_SpeedProfile2_S.sfan_speedprofile2_s, SFAN_SpeedProfile2_D.sfan_speedprofile2_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile2 : class SFAN_SpeedProfile2
            public static class SFAN_SpeedProfile2
            {
                public const string description = "Profile 2, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile2 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 60;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(2, SFAN_SpeedProfile2.sfan_speedprofile2, SFAN_SpeedProfile2_S.sfan_speedprofile2_s, SFAN_SpeedProfile2_D.sfan_speedprofile2_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile2_D : class SFAN_SpeedProfile2_D
            public static class SFAN_SpeedProfile2_D
            {
                public const string description = "Profile 2, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile2_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 30;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(2, SFAN_SpeedProfile2.sfan_speedprofile2, SFAN_SpeedProfile2_S.sfan_speedprofile2_s, SFAN_SpeedProfile2_D.sfan_speedprofile2_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV3 : class SFAN_DIV3
            public static class SFAN_DIV3
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div3 = 3;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile3_S : class SFAN_SpeedProfile3_S
            public static class SFAN_SpeedProfile3_S
            {
                public const string description = "Profile 3, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile3_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 165;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(3, SFAN_SpeedProfile3.sfan_speedprofile3, SFAN_SpeedProfile3_S.sfan_speedprofile3_s, SFAN_SpeedProfile3_D.sfan_speedprofile3_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile3 : class SFAN_SpeedProfile3
            public static class SFAN_SpeedProfile3
            {
                public const string description = "Profile 3, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile3 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 70;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(3, SFAN_SpeedProfile3.sfan_speedprofile3, SFAN_SpeedProfile3_S.sfan_speedprofile3_s, SFAN_SpeedProfile3_D.sfan_speedprofile3_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile3_D : class SFAN_SpeedProfile3_D
            public static class SFAN_SpeedProfile3_D
            {
                public const string description = "Profile 3, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile3_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 57;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(3, SFAN_SpeedProfile3.sfan_speedprofile3, SFAN_SpeedProfile3_S.sfan_speedprofile3_s, SFAN_SpeedProfile3_D.sfan_speedprofile3_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV4 : class SFAN_DIV4
            public static class SFAN_DIV4
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div4 = 4;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile4_S : class SFAN_SpeedProfile4_S
            public static class SFAN_SpeedProfile4_S
            {
                public const string description = "Profile 4, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile4_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 188;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(4, SFAN_SpeedProfile4.sfan_speedprofile4, SFAN_SpeedProfile4_S.sfan_speedprofile4_s, SFAN_SpeedProfile4_D.sfan_speedprofile4_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile4 : class SFAN_SpeedProfile4
            public static class SFAN_SpeedProfile4
            {
                public const string description = "Profile 4, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile4 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 80;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(4, SFAN_SpeedProfile4.sfan_speedprofile4, SFAN_SpeedProfile4_S.sfan_speedprofile4_s, SFAN_SpeedProfile4_D.sfan_speedprofile4_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile4_D : class SFAN_SpeedProfile4_D
            public static class SFAN_SpeedProfile4_D
            {
                public const string description = "Profile 4, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile4_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 67;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(4, SFAN_SpeedProfile4.sfan_speedprofile4, SFAN_SpeedProfile4_S.sfan_speedprofile4_s, SFAN_SpeedProfile4_D.sfan_speedprofile4_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV5 : class SFAN_DIV5
            public static class SFAN_DIV5
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div5 = 5;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile5_S : class SFAN_SpeedProfile5_S
            public static class SFAN_SpeedProfile5_S
            {
                public const string description = "Profile 5, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile5_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 213;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(5, SFAN_SpeedProfile5.sfan_speedprofile5, SFAN_SpeedProfile5_S.sfan_speedprofile5_s, SFAN_SpeedProfile5_D.sfan_speedprofile5_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile5 : class SFAN_SpeedProfile5
            public static class SFAN_SpeedProfile5
            {
                public const string description = "Profile 5, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile5 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 90;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(5, SFAN_SpeedProfile5.sfan_speedprofile5, SFAN_SpeedProfile5_S.sfan_speedprofile5_s, SFAN_SpeedProfile5_D.sfan_speedprofile5_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile5_D : class SFAN_SpeedProfile5_D
            public static class SFAN_SpeedProfile5_D
            {
                public const string description = "Profile 5, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile5_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 77;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(5, SFAN_SpeedProfile5.sfan_speedprofile5, SFAN_SpeedProfile5_S.sfan_speedprofile5_s, SFAN_SpeedProfile5_D.sfan_speedprofile5_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_DIV6 : class SFAN_DIV6
            public static class SFAN_DIV6
            {
                public const string description = "Profile";
                public const bool nhc_visible = true;
                public static int sfan_div6 = 6;
                public const string unit = "";
            }
            #endregion

            #region Value class for SFAN_SpeedProfile6_S : class SFAN_SpeedProfile6_S
            public static class SFAN_SpeedProfile6_S
            {
                public const string description = "Profile 6, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile6_s = 0;
                public const string unit = "";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 255;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(6, SFAN_SpeedProfile6.sfan_speedprofile6, SFAN_SpeedProfile6_S.sfan_speedprofile6_s, SFAN_SpeedProfile6_D.sfan_speedprofile6_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile6 : class SFAN_SpeedProfile6
            public static class SFAN_SpeedProfile6
            {
                public const string description = "Profile 6, the highest CPU temperature allowed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile6 = 0;
                public const string unit = "°C";
                public static bool initialisation = false;

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 100;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(6, SFAN_SpeedProfile6.sfan_speedprofile6, SFAN_SpeedProfile6_S.sfan_speedprofile6_s, SFAN_SpeedProfile6_D.sfan_speedprofile6_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfile6_D : class SFAN_SpeedProfile6_D
            public static class SFAN_SpeedProfile6_D
            {
                public const string description = "Profile 6, deactivate profile if CPU temperature is below or equals to";
                public const bool nhc_visible = true;
                public static int sfan_speedprofile6_d = 0;
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 100;
                    public const int nhc_default_value = 87;

                    public static bool nhc_on_write()
                    {
                        SFAN_UpdateProfile(6, SFAN_SpeedProfile6.sfan_speedprofile6, SFAN_SpeedProfile6_S.sfan_speedprofile6_s, SFAN_SpeedProfile6_D.sfan_speedprofile6_d);
                        return true;
                    }
                }
            }
            #endregion

            #region Value class for SFAN_SpeedProfileDefault : class SFAN_SpeedProfileDefault
            public static class SFAN_SpeedProfileDefault
            {
                public const string description = "Default profile, fan speed";
                public const bool nhc_visible = true;
                public static int sfan_speedprofiledefault = 255;
                public const string unit = "";
                public static bool initialisation = false;
            }
            #endregion

            public const int refresh_interval = 1;
            public static bool refresh()
            {
                if (!SFAN_Profile.init_done)
                {
                    SFAN_UpdateProfile(1, SFAN_SpeedProfile1.sfan_speedprofile1, SFAN_SpeedProfile1_S.sfan_speedprofile1_s, SFAN_SpeedProfile1_D.sfan_speedprofile1_d);
                    SFAN_UpdateProfile(2, SFAN_SpeedProfile2.sfan_speedprofile2, SFAN_SpeedProfile2_S.sfan_speedprofile2_s, SFAN_SpeedProfile2_D.sfan_speedprofile2_d);
                    SFAN_UpdateProfile(3, SFAN_SpeedProfile3.sfan_speedprofile3, SFAN_SpeedProfile3_S.sfan_speedprofile3_s, SFAN_SpeedProfile3_D.sfan_speedprofile3_d);
                    SFAN_UpdateProfile(4, SFAN_SpeedProfile4.sfan_speedprofile4, SFAN_SpeedProfile4_S.sfan_speedprofile4_s, SFAN_SpeedProfile4_D.sfan_speedprofile4_d);
                    SFAN_UpdateProfile(5, SFAN_SpeedProfile5.sfan_speedprofile5, SFAN_SpeedProfile5_S.sfan_speedprofile5_s, SFAN_SpeedProfile5_D.sfan_speedprofile5_d);
                    SFAN_UpdateProfile(6, SFAN_SpeedProfile6.sfan_speedprofile6, SFAN_SpeedProfile6_S.sfan_speedprofile6_s, SFAN_SpeedProfile6_D.sfan_speedprofile6_d);
                    SFAN_OnRefresh(true);
                    SFAN_Profile.init_done = true;
                }
                if (SFAN_UpdateSpeed.sfan_refreshdivider < SFAN_UpdateSpeed.sfan_updatespeed)
                {
                    SFAN_UpdateSpeed.sfan_refreshdivider++;
                    return true;
                }
                SFAN_UpdateSpeed.sfan_refreshdivider = 0;
                SFAN_OnRefresh(false);
                return true;
            }

            private static bool SFAN_OnRefresh(bool force_refresh)
            {
                int temperature_current = 0;
                int speed_current = 0;
                int profile_current = SFAN_Profile.sfan_profile;
                bool ok = false;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref temperature_current);
                temperature_current = (temperature_current - 2732) / 10;
                ACPI.METHOD.GetValue("_TZ.RFAN", ref speed_current);
                speed_current = speed_current * 100;
                if (force_refresh)
                {
                    for (int i = 0; i < 6; i++)
                    {
                        if (temperature_current <= SFAN_Profile.t_[i])
                        {
                            SFAN_SetCPUFanSpeed(SFAN_Profile.s_[i], SFAN_Profile.t_[i]);
                            SFAN_Profile.sfan_profile = SFAN_Profile.i_[i];
                            SFAN_Profile.sfan_profile_i = i;
                            ok = true;
                            break;
                        }
                    }
                }
                else
                {
                    for (int i = 0; i < 6; i++)
                    {
                        if (temperature_current <= SFAN_Profile.t_[i])
                        {
                            if (SFAN_Profile.sfan_profile_i > i) // spin down
                            {
                                if (temperature_current <= SFAN_Profile.d_[SFAN_Profile.sfan_profile_i])
                                {
                                    SFAN_SetCPUFanSpeed(SFAN_Profile.s_[i], SFAN_Profile.t_[i]);
                                    SFAN_Profile.sfan_profile = SFAN_Profile.i_[i];
                                    SFAN_Profile.sfan_profile_i = i;
                                }
                            }
                            else if (SFAN_Profile.sfan_profile_i < i) // spin up
                            {
                                SFAN_SetCPUFanSpeed(SFAN_Profile.s_[i], SFAN_Profile.t_[i]);
                                SFAN_Profile.sfan_profile = SFAN_Profile.i_[i];
                                SFAN_Profile.sfan_profile_i = i;
                            }
                            else if (SFAN_Profile.sfan_profile_i == i) // same profile
                            {
                                if (speed_current != SFAN_FanSpeed.sfan_fanspeed)
                                {
                                    SFAN_SetCPUFanSpeed(SFAN_Profile.s_[i], SFAN_Profile.t_[i]);
                                    SFAN_Profile.sfan_profile = SFAN_Profile.i_[i];
                                    SFAN_Profile.sfan_profile_i = i;
                                }
                            }
                            ok = true;
                            break;
                        }
                    }
                }
                if (!ok)
                {
                    SFAN_SetCPUFanSpeed(255, 100);
                }
                SFAN_CPUTemperature.sfan_cputemperature = temperature_current;
                return true;
            }

            private static bool SetFanSpeed(int _HLMT, int _FANV)
            {
                int value_TSAD = 0;
                int[] inArg_WBYT = { 0, 0, 0 };
                int[] inArg_RBYT = { 0, 0 };
                int[] outArg = { 0 };

                // Get value of TSAD member of RAMW fieled
                ACPI.FIELD.Read("TSAD", ref value_TSAD);

                // WBYT (TSAD, 0x4F, HLMT)
                inArg_WBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_WBYT[1] = 0x4F;       // Unknown constant; refer to W1J's DSDT disassembly
                inArg_WBYT[2] = _HLMT;      // Higher temperature trigger limit; BIOS will activate hardware fan control if temperature would above this limit
                ACPI.METHOD.Call("WBYT", inArg_WBYT, 3, ref outArg, 1);

                // WBYT (TSAD, 0x4E, LLMT)
                inArg_WBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_WBYT[1] = 0x4E;       // Unknown constant; refer to W1J's DSDT disassembly
                inArg_WBYT[2] = 0;          // Lower temperature trigger limit; set to zero to prevent hardware fan control activation
                ACPI.METHOD.Call("WBYT", inArg_WBYT, 3, ref outArg, 1);

                // WBYT (TSAD, 0x30, FANV)
                inArg_WBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_WBYT[1] = 0x30;       // Unknown constant; refer to W1J's DSDT disassembly
                inArg_WBYT[2] = _FANV;      // ACPI fan speed; BIOS uses values: 0, 127, 153, 230, 255
                ACPI.METHOD.Call("WBYT", inArg_WBYT, 3, ref outArg, 1);

                // RBYT (TSAD, 0x41)
                inArg_RBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_RBYT[1] = 0x41;       // Unknown constant; refer to W1J's DSDT disassembly
                ACPI.METHOD.Call("RBYT", inArg_RBYT, 2, ref outArg, 1);

                // RBYT (TSAD, 0x42)
                inArg_RBYT[0] = value_TSAD; // Value of TSAD member of RAMW fieled
                inArg_RBYT[1] = 0x41;       // Unknown constant; refer to W1J's DSDT disassembly
                ACPI.METHOD.Call("RBYT", inArg_RBYT, 2, ref outArg, 1);

                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed, int maxtemperature)
            {
                int tmpvalue = 0;
                SetFanSpeed(SFAN_WARNING.sfan_warning, speed);
                //SFAN_WARNING.sfan_warning = maxtemperature + 5;
                ACPI.METHOD.GetValue("_TZ.RFAN", ref tmpvalue);
                SFAN_FanSpeed.sfan_fanspeed = tmpvalue * 100;
                return true;
            }

            private static bool SFAN_UpdateProfile(int profile, int maxtemperature, int speed, int mintemperature)
            {
                int idx = 0;
                for (int i = 0; i < 6; i++)
                {
                    if (SFAN_Profile.i_[i] == profile)
                    {
                        idx = i;
                        break;
                    }
                }
                SFAN_Profile.t_[idx] = maxtemperature;
                SFAN_Profile.s_[idx] = speed;
                SFAN_Profile.d_[idx] = mintemperature;
                int tmp;
                for (int i = 1; i < 6; i++)
                {
                    for (int j = 5; j > 0; j--)
                    {
                        if (SFAN_Profile.t_[j - 1] > SFAN_Profile.t_[j])
                        {
                            tmp = SFAN_Profile.t_[j];
                            SFAN_Profile.t_[j] = SFAN_Profile.t_[j - 1];
                            SFAN_Profile.t_[j - 1] = tmp;
                            tmp = SFAN_Profile.s_[j];
                            SFAN_Profile.s_[j] = SFAN_Profile.s_[j - 1];
                            SFAN_Profile.s_[j - 1] = tmp;
                            tmp = SFAN_Profile.i_[j];
                            SFAN_Profile.i_[j] = SFAN_Profile.i_[j - 1];
                            SFAN_Profile.i_[j - 1] = tmp;
                            tmp = SFAN_Profile.d_[j];
                            SFAN_Profile.d_[j] = SFAN_Profile.d_[j - 1];
                            SFAN_Profile.d_[j - 1] = tmp;
                        }
                    }
                }
                if (SFAN_Profile.init_done) SFAN_OnRefresh(true);
                return true;
            }
        }
        #endregion
    }
    #endregion

    #region Notebook Asus W1V : class W1V
    //
    // Class author: t6m4n232v57@gmx.li
    // Version: 15.04.2007
    // Bios Version: 211
    //
    public static class W1V
    {
        public const string author = "t6m4n232v57@gmx.li";

        #region Class for Asus W1V LCD Brightness control : class BRIGHTNESS    // The class must have the name BRIGHTNESS
        public static class BRIGHTNESS
        {
            public const string description = "LCD-Brightness Control";
            public const bool default_enabled = false;
            public const int icon = 1;    // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public const int minimum_brightness_level = 0;    //
            public const int maximum_brightness_level = 15;   // to detect brightness change by keystroke
            public const int brightness_level_step = 1;   //

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            public static class BRIGHTNESS_LEVEL
            {
                public const string description = "LCD brightness level (0-15)";
                public const bool nhc_visible = true;
                public static int brightness_level = 0;
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 15;
                    public const int nhc_default_value = 15;
                    public static bool nhc_on_write()
                    {
                        ACPI.METHOD.SetValue("_SB.ATKD.SPLV", BRIGHTNESS_LEVEL.brightness_level);
                        return true;
                    }
                }
            }
            #endregion

            public static bool set_brightness(int new_level)
            {
                ACPI.METHOD.SetValue("_SB.ATKD.SPLV", BRIGHTNESS_LEVEL.brightness_level);
                return true;
            }

            public static bool get_brightness(ref int level)
            {
                bool result = true;
                ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref level);   // get current brightness level
                BRIGHTNESS_LEVEL.brightness_level = level;
                return result;
            }
        }
        #endregion

        #region Class for Asus W1V SFAN control : class SFAN
        public static class SFAN
        {
            public const string description = "ACPI Intelligent RPM/°C Fan Control";
            public const bool default_enabled = true;
            public const int icon = 2;
            #region Value class for SFAN_CPUTemperature : class SFAN_CPUTemperature
            public static class SFAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for SFAN_FanSpeed : class SFAN_FanSpeed
            public static class SFAN_FanSpeed
            {
                public const string description = "Current fan speed (80-255, 0=off)";
                public const bool nhc_visible = true;
                public static int sfan_fanspeed = 0;
                public const string unit = "";
                public static int sfan_refreshdivider = 0;
            }
            #endregion

            #region Value class for SFAN_UpdateSpeed : class SFAN_UpdateSpeed
            public static class SFAN_UpdateSpeed
            {
                public const string description = "Update fan speed every";
                public const bool nhc_visible = true;
                public static int sfan_updatespeed = 0;
                public const string unit = " second(s)";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 1;
                    public const int nhc_maximum_value = 10;
                    public const int nhc_default_value = 3;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            #region Value class for SFAN_MaxTemperature : class SFAN_MaxTemperature
            public static class SFAN_MaxTemperature
            {
                public const string description = "Maximum fan speed CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_maxtemperature = 0;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 65;
                    public const int nhc_maximum_value = 85;
                    public const int nhc_default_value = 75;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            #region Value class for SFAN_MinTemperature : class SFAN_MinTemperature
            public static class SFAN_MinTemperature
            {
                public const string description = "Fan start CPU temperature";
                public const bool nhc_visible = true;
                public static int sfan_mintemperature = 0;
                public const string unit = "°C";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 35;
                    public const int nhc_maximum_value = 55;
                    public const int nhc_default_value = 45;
                    public static bool nhc_on_write()
                    {
                        return true;    // nothing to do; value used only by timer
                    }
                }
            }
            #endregion

            public static bool refresh()
            {
                if (SFAN_FanSpeed.sfan_refreshdivider + 1 < SFAN_UpdateSpeed.sfan_updatespeed)    // delay-loop
                {
                    SFAN_FanSpeed.sfan_refreshdivider++;
                    return true;
                }
                SFAN_FanSpeed.sfan_refreshdivider = 0;
                int temperature_current = 0;
                int speed_current = 0;
                int temperature_min = SFAN_MinTemperature.sfan_mintemperature;
                int temperature_max = SFAN_MaxTemperature.sfan_maxtemperature;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref temperature_current);
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref speed_current);
                temperature_current = (temperature_current - 2732) / 10;    // conversion to celsius
                int fan_speed = (temperature_current - temperature_min) * 175 / (temperature_max - temperature_min) + 80;   // calculating fan_speed
                if (fan_speed > 79)   // fan starts spinning only > 75
                {
                    if (fan_speed != speed_current) SFAN_SetCPUFanSpeed(fan_speed);   // to avoid useless updating
                }
                else
                {
                    if (speed_current != 0)   // to avoid useless updating
                    {
                        SFAN_SetCPUFanSpeed(0);
                        ACPI.NAME.Write("_TZ.PLCY", 1);
                    }
                }
                SFAN_CPUTemperature.sfan_cputemperature = temperature_current;
                SFAN_FanSpeed.sfan_fanspeed = speed_current;
                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed)    // the speed-setting-thing
            {
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                ACPI.NAME.Write("_TZ.PLCY", 0);
                return true;
            }
        }
        #endregion

        #region Class for Asus W1V FAN control : class FAN
        public static class FAN
        {
            public const string description = "ACPI Manual Fan Control";
            public const bool default_enabled = false;
            public const int icon = 2;
            #region Value class for FAN_CPUTemperature : class FAN_CPUTemperature
            public static class FAN_CPUTemperature
            {
                public const string description = "Current CPU temperature";
                public const bool nhc_visible = true;
                public static int fan_cputemperature = 0;
                public const string unit = "°C";
            }
            #endregion

            #region Value class for FAN_FanSpeed : class FAN_FanSpeed
            public static class FAN_FanSpeed
            {
                public const string description = "Current fan speed (0-255, 0=off)";
                public const bool nhc_visible = true;
                public static int fan_fanspeed = 0;
                public const string unit = "";
            }
            #endregion

            public static class FAN_ON_OFF
            {
                public const string description = "Fan switch (on/off)";
                public const bool nhc_visible = true;
                public static int fan_on_off = 0;
                public const string unit = "off|on";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 1;
                    public const int nhc_default_value = 1;
                    public static bool initialisation = false;
                    public static bool nhc_on_write()
                    {
                        if (!initialisation)    // avoids "wtf, it says 'off' but it's on?"
                        {
                            int a = 0;
                            ACPI.NAME.Read("_TZ.PLCY", ref a);
                            FAN_ON_OFF.fan_on_off = ((a == 0) ? 1 : 0);
                            initialisation = true;
                            return true;
                        }

                        if (fan_on_off != 0)    // on and off
                        {
                            SFAN_SetCPUFanSpeed(FAN_SPEED.fan_speed);
                            ACPI.NAME.Write("_TZ.PLCY", 0);
                        }
                        else
                        {
                            SFAN_SetCPUFanSpeed(0);
                            ACPI.NAME.Write("_TZ.PLCY", 1);
                        }
                        return true;
                    }
                }
            }
            public static class FAN_SPEED
            {
                public const string description = "Update fan speed to (0 to 255)";
                public const bool nhc_visible = true;
                public static int fan_speed = 0;
                public const string unit = "";
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 0;
                    public const int nhc_maximum_value = 255;
                    public const int nhc_default_value = 167;

                    public static bool nhc_on_write()
                    {
                        int is_fan_off = 0;
                        ACPI.NAME.Read("_TZ.PLCY", ref is_fan_off);
                        if (is_fan_off == 0)    // only has effect while fan is "switched" on
                        {
                            SFAN_SetCPUFanSpeed(fan_speed);
                            return true;
                        }
                        return true;
                    }
                }
            }

            public static bool refresh()
            {
                int cpu_current = 0;    // updating temp & rpm
                int fan_current = 0;
                ACPI.FIELD.Read("_TZ.THRM._TMP", ref cpu_current);
                ACPI.FIELD.Read("_SB.PCI0.SBRG.EC0.CDT1", ref fan_current);
                FAN_CPUTemperature.fan_cputemperature = (cpu_current - 2732) / 10;
                FAN_FanSpeed.fan_fanspeed = fan_current;
                return true;
            }

            private static bool SFAN_SetCPUFanSpeed(int speed)    // the speed-setting-thing
            {
                int a, b, c, res;
                a = 0x84;
                b = speed;
                c = 0xC4;
                res = ((a << 16) + (b << 8) + (c));
                ACPI.METHOD.SetValue("_SB.ATKD.ECRW", res);
                return true;
            }
        }
        #endregion

        #region Class for ASUS W1V Hardware control : class HARDWARE
        public static class HARDWARE
        {
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_CONTROL : class WLAN_CONTROL
            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            #endregion

            #region Value class for BLUETOOTH_CONTROL : class BLUETOOTH_CONTROL
            public static class BLUETOOTH_CONTROL
            {
                // Properties of the value class
                public const string description = "Bluetooth";                      // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bluetooth_control = 1;                            // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (bluetooth_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 0);        // turn off the bluetooth
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 1);        // turn on the bluetooth
                        }
                    }
                }
            }
            #endregion
        }
        #endregion
    }
    #endregion

    #region Notebook ASUS W3V : class W3V
    //
    // class author: Manfred Jaider
    //
    public static class W3V
    {
        public const string author = "Manfred Jaider";

        #region Class for ASUS W3V LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control";             // Description of current class
            public const bool default_enabled = true;                               // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 15;
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            //
            public static class BRIGHTNESS_LEVEL
            {
                // Properties of the value class
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                return A7D.BRIGHTNESS.set_brightness(new_level);                    // we can use the ASUS A7D set_brightness function (brightness control works in the same way)
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                return A7D.BRIGHTNESS.get_brightness(ref level);                    // we can use the ASUS A7D get_brightness function (brightness control works in the same way)
            }
        }
        //
        #endregion

        #region Class for ASUS W3V Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            #region Value class for WLAN_CONTROL : class WLAN_CONTROL
            //
            public static class WLAN_CONTROL
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_control = 1;                                 // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (wlan_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 0);        // turn off the WLAN
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.WLED", 1);        // turn on the WLAN
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for BLUETOOTH_CONTROL : class BLUETOOTH_CONTROL
            //
            public static class BLUETOOTH_CONTROL
            {
                // Properties of the value class
                public const string description = "Bluetooth";                      // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bluetooth_control = 1;                            // It must have the same name as the class (case are ignored)
                public const string unit = "OFF|ON";                                // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // the minimum value of wlan_status
                    public const int nhc_maximum_value = 1;                         // the maximum value of wlan_status
                    public const int nhc_default_value = 1;                         // the default value of wlan_status
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (bluetooth_control == 0)
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 0);        // turn off the bluetooth
                        }
                        else
                        {
                            return ACPI.METHOD.SetValue("_SB.ATKD.BLED", 1);        // turn on the bluetooth
                        }
                    }
                }
            }
            //
            #endregion

        }
        //
        #endregion

        #region Class for Asus W3V FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                              // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Name (FSTL, Package (0x06)
            // {
            //    0x00,         // 0*rmp        // FAN OFF
            //    0x80,         // 128*rpm      // FAN low speed
            //    0xA3,         // 163*rpm      // FAN middle speed
            //    0xCC,         // 204*rpm      // FAN high speed
            //    0xFF,         // 255*rpm      // FAN maximum speed
            //    0xFF          // 255*rpm
            // })

            #region Value class for FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public static class FAN_LOW_SPEED
            {
                // Properties of the value class
                public const string description = "FAN low speed";                  // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_low_speed = 128;                              // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 50;                        // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 128;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[1]", fan_low_speed) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public static class FAN_MIDDLE_SPEED
            {
                // Properties of the value class
                public const string description = "FAN middle speed";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_middle_speed = 163;                           // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 100;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 163;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[2]", fan_middle_speed) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public static class FAN_HIGH_SPEED
            {
                // Properties of the value class
                public const string description = "FAN high speed";                 // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fan_high_speed = 204;                             // It must have the same name as the class (case are ignored)
                public const string unit = "*rpm";                                  // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 150;                       // minimum input value
                    public const int nhc_maximum_value = 255;                       // maximum input value
                    public const int nhc_default_value = 204;                       // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.FSTL", "PKG[3]", fan_high_speed) == true)     // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion


            // Name (HTTL, Package (0x06)
            // {
            //    0x28,         // 45°C     <- FAN ON low level
            //    0x37,         // 55°C     <- FAN ON middle level
            //    0x4E,         // 78°C     <- FAN ON high level
            //    0x5A,         // 90°C     <- FAN ON maximum level
            //    0x7F,         // 127°C
            //    0x7F          // 127°C
            // })
            // Name (LTTL, Package (0x06)
            // {
            //    0x00,
            //    0x23,         // 35°C     <- FAN OFF low level
            //    0x32,         // 50°C     <- FAN OFF middle level
            //    0x3C,         // 60°C     <- FAN OFF high level
            //    0x53,         // 83°C     <- FAN OFF maximum level
            //    0x7F          // 127°C
            // })

            #region Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 35;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 50;                        // maximum input value
                    public const int nhc_default_value = 35;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[1]", low_level_off) == true)    // set the low_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 45;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // minimum input value
                    public const int nhc_maximum_value = 65;                        // maximum input value
                    public const int nhc_default_value = 45;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[0]", low_level_on) == true)     // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_OFF : class MIDDLE_LEVEL_OFF
            //
            public static class MIDDLE_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_off = 50;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[2]", middle_level_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_on = 55;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 55;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[1]", middle_level_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 60;                              // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.LTTL", "PKG[4]", high_level_off) == true)   // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 78;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 30;                        // minimum input value
                    public const int nhc_maximum_value = 85;                        // maximum input value
                    public const int nhc_default_value = 78;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.HTTL", "PKG[2]", high_level_on) == true)    // set the value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return ACPI.METHOD.Call("_TZ.STRP");                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_TZ.STRP");                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

}

